/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.interaction.DeepDrillEntity;
import rearth.oritech.block.entity.processing.AtomicForgeBlockEntity;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.MultiblockMachineController;

public class TooltipHelper {
    public static String getEnergyText(long amount) {
        if (amount < 1000L) {
            return String.valueOf(amount);
        }
        if (amount < 1000000L) {
            return TooltipHelper.getFormatted((double)amount / 1000.0) + class_1074.method_4662((String)"tooltip.oritech.thousand_abbrev", (Object[])new Object[0]);
        }
        if (amount < 1000000000L) {
            return TooltipHelper.getFormatted((double)amount / 1000000.0) + class_1074.method_4662((String)"tooltip.oritech.million_abbrev", (Object[])new Object[0]);
        }
        if (amount < 1000000000000L) {
            return TooltipHelper.getFormatted((double)amount / 1.0E9) + class_1074.method_4662((String)"tooltip.oritech.billion_abbrev", (Object[])new Object[0]);
        }
        return TooltipHelper.getFormatted((double)amount / 1.0E12) + class_1074.method_4662((String)"tooltip.oritech.trillion_abbrev", (Object[])new Object[0]);
    }

    private static String getFormatted(double number) {
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.ROOT);
        formatter.setMinimumFractionDigits(0);
        formatter.setMaximumFractionDigits(2);
        return formatter.format(number);
    }

    public static void addMachineTooltip(List<class_2561> tooltip, class_2248 block, class_2343 entityProvider) {
        boolean showExtra = class_437.method_25441();
        if (showExtra) {
            MachineBlockEntity machineEntity;
            class_2586 entity = entityProvider.method_10123(class_2338.field_10980, block.method_9564());
            if (entity instanceof MultiblockMachineController) {
                MultiblockMachineController multiblockController = (MultiblockMachineController)entity;
                List<class_2382> corePositions = multiblockController.getCorePositions();
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.core_desc").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(corePositions.size())).method_27692(class_124.field_1065)));
            }
            if (entity instanceof FrameInteractionBlockEntity) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.frame_needed").method_27692(class_124.field_1080));
            }
            if (entity instanceof MachineAddonController) {
                MachineAddonController addonProvider = (MachineAddonController)entity;
                List<class_2382> addonSlots = addonProvider.getAddonSlots();
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_desc").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(addonSlots.size())).method_27692(class_124.field_1065)));
            }
            if (entity instanceof MachineBlockEntity && (machineEntity = (MachineBlockEntity)entity).getEnergyPerTick() > 1) {
                int energyRate = machineEntity.getEnergyPerTick();
                if (entity instanceof UpgradableGeneratorBlockEntity) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.generator_rate_desc").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43469((String)"tooltip.oritech.energy_transfer_rate", (Object[])new Object[]{energyRate}).method_27692(class_124.field_1065)));
                } else if (entity instanceof MachineBlockEntity) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.machine_rate_desc").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43469((String)"tooltip.oritech.energy_transfer_rate", (Object[])new Object[]{energyRate}).method_27692(class_124.field_1065)));
                }
            } else if (entity instanceof ExpandableEnergyStorageBlockEntity) {
                ExpandableEnergyStorageBlockEntity energyStorage = (ExpandableEnergyStorageBlockEntity)entity;
                long transferRate = energyStorage.getDefaultExtractionRate();
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.energy_max_transfer").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43469((String)"tooltip.oritech.energy_transfer_rate", (Object[])new Object[]{transferRate}).method_27692(class_124.field_1065)));
            }
            if (entity instanceof EnergyApi.BlockProvider) {
                class_2960 id;
                EnergyApi.BlockProvider energyProvider = (EnergyApi.BlockProvider)entity;
                String maxStorage = TooltipHelper.getEnergyText(energyProvider.getEnergyStorage(null).getCapacity());
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.machine_capacity_desc").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43469((String)"tooltip.oritech.energy_capacity", (Object[])new Object[]{maxStorage}).method_27692(class_124.field_1065)));
                if (energyProvider instanceof AtomicForgeBlockEntity || energyProvider instanceof DeepDrillEntity) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.needs_laser_power").method_27692(class_124.field_1067));
                }
                if (class_1074.method_4663((String)("tooltip.oritech." + (id = class_7923.field_41175.method_10221((Object)block)).method_12832() + ".extra"))) {
                    tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.oritech." + id.method_12832() + ".extra")).method_27692(class_124.field_1080));
                }
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
    }

    public static class_2561 getFormattedEnergyChangeTooltip(long amount, String unit) {
        String formatted = TooltipHelper.getEnergyText(amount);
        Object text = amount > 0L ? "+" + formatted : formatted;
        return class_2561.method_43470((String)text).method_27692(class_124.field_1065).method_27693(unit).method_27692(class_124.field_1065);
    }

    public static class_2561 getFormattedValueChangeTooltip(int amount) {
        Object text = amount > 0 ? "+" + amount : String.valueOf(amount);
        class_124 color = amount > 0 ? class_124.field_1060 : class_124.field_1061;
        return class_2561.method_43470((String)text).method_27692(color).method_27693("%").method_27692(color);
    }
}

