/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.arcane;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.arcane.BaseSoulCollectionEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.CatalystScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnchantmentCatalystBlockEntity
extends BaseSoulCollectionEntity
implements ItemApi.BlockProvider,
EnergyApi.BlockProvider,
ScreenProvider,
ComparatorOutputProvider,
GeoBlockEntity,
class_5558<EnchantmentCatalystBlockEntity>,
ExtendedMenuProvider {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation STABILIZED = RawAnimation.begin().thenLoop("stabilized");
    public static final RawAnimation UNSTABLE = RawAnimation.begin().thenLoop("unstable");
    public static final RawAnimation EMPTY = RawAnimation.begin().thenLoop("empty");
    public final int baseSoulCapacity = Oritech.CONFIG.catalystBaseSouls();
    public final int maxProgress = 20;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int collectedSouls;
    public int maxSouls = Oritech.CONFIG.catalystBaseSouls();
    private int unstableTicks;
    private int progress;
    private boolean isHyperEnchanting;
    private boolean networkDirty;
    private String lastAnimation = "invalid";
    private int lastComparatorOutput;
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(this, 2, () -> ((EnchantmentCatalystBlockEntity)this).method_5431()){

        @Override
        public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
            if (slot == 0 && !addedStack.method_7960() && !addedStack.method_7909().equals(class_1802.field_8598)) {
                return 0;
            }
            return super.insertToSlot(addedStack, slot, simulate);
        }
    };
    public final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(10000L, 0L, 50000L);

    public EnchantmentCatalystBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ENCHANTMENT_CATALYST_BLOCK_ENTITY, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, EnchantmentCatalystBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (this.energyStorage.getAmount() > 0L) {
            long gainedSoulCapacity = this.energyStorage.getAmount() / (long)Oritech.CONFIG.catalystRFPerSoul();
            this.energyStorage.setAmount(0L);
            long newMax = (long)this.baseSoulCapacity + gainedSoulCapacity;
            this.adjustMaxSouls(newMax);
            this.method_5431();
        } else if (this.maxSouls > this.baseSoulCapacity) {
            this.adjustMaxSouls(this.baseSoulCapacity);
        }
        if (this.collectedSouls > this.maxSouls) {
            ++this.unstableTicks;
            ParticleContent.MELTDOWN_IMMINENT.spawn(world, pos.method_46558(), (Object)(this.unstableTicks / 4));
            if (this.unstableTicks > 60) {
                this.doExplosion();
            }
            return;
        }
        this.unstableTicks = 0;
        if (this.canProceed()) {
            this.networkDirty = true;
            ++this.progress;
            ParticleContent.SOUL_USED.spawn(world, pos.method_46558().method_1031(0.0, 0.3, 0.0), (Object)(this.isHyperEnchanting ? 15 : 3));
            if (this.progress >= 20) {
                this.enchantInput();
                ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.method_46558(), (Object)30);
                this.progress = 0;
                this.isHyperEnchanting = false;
            }
        } else {
            this.progress = 0;
        }
        if (this.networkDirty) {
            this.networkDirty = false;
            this.updateNetwork();
            BaseSoulCollectionEntity.DeathListener.resetEvents();
            this.updateAnimation();
            int level = this.calculateComparatorLevel();
            if (level != this.lastComparatorOutput) {
                this.lastComparatorOutput = level;
                world.method_8455(pos, state.method_26204());
            }
        }
        if (world.method_8510() % 60L == 0L) {
            this.lastAnimation = "invalid";
            this.updateAnimation();
        }
    }

    private boolean isEmpty() {
        return this.collectedSouls <= 0;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.inventory.heldStacks, (boolean)false, (class_7225.class_7874)registryLookup);
        nbt.method_10569("souls", this.collectedSouls);
        nbt.method_10569("maxSouls", this.maxSouls);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory.heldStacks, (class_7225.class_7874)registryLookup);
        this.collectedSouls = nbt.method_10550("souls");
        this.maxSouls = nbt.method_10550("maxSouls");
    }

    private void doExplosion() {
        class_243 center = this.field_11867.method_46558();
        double strength = Math.sqrt(this.collectedSouls - this.baseSoulCapacity);
        this.field_11863.method_8537(null, center.field_1352, center.field_1351, center.field_1350, (float)((int)strength), true, class_1937.class_7867.field_40889);
        this.field_11863.method_8650(this.field_11867, false);
    }

    private void adjustMaxSouls(long target) {
        if ((long)this.maxSouls > target) {
            --this.maxSouls;
        } else if ((long)this.maxSouls < target) {
            ++this.maxSouls;
        }
        this.networkDirty = true;
    }

    private void enchantInput() {
        class_1799 bookCandidate = this.inventory.method_5438(0);
        if (!bookCandidate.method_7909().equals(class_1802.field_8598) || !bookCandidate.method_57826(class_9334.field_49643)) {
            return;
        }
        class_6880 enchantment = (class_6880)((class_9304)bookCandidate.method_57824(class_9334.field_49643)).method_57534().stream().findFirst().get();
        class_1799 inputStack = this.inventory.method_5438(1);
        int toolLevel = inputStack.method_58657().method_57536(enchantment);
        inputStack.method_7978(enchantment, toolLevel + 1);
        this.collectedSouls -= this.getEnchantmentCost((class_1887)enchantment.comp_349(), toolLevel + 1, this.isHyperEnchanting);
        if (this.isHyperEnchanting) {
            this.inventory.method_5447(0, class_1799.field_8037);
        }
    }

    private boolean hasEnoughSouls(class_1887 enchantment, int targetLevel) {
        int resultingCost = this.getEnchantmentCost(enchantment, targetLevel, this.isHyperEnchanting);
        return this.collectedSouls >= resultingCost;
    }

    private int getEnchantmentCost(class_1887 enchantment, int targetLevel, boolean hyper) {
        int baseCost = enchantment.method_58446();
        int resultingCost = baseCost * targetLevel * Oritech.CONFIG.catalystCostMultiplier();
        if (hyper) {
            resultingCost = (int)(Math.pow(resultingCost * Oritech.CONFIG.catalystHyperMultiplier(), Oritech.CONFIG.catalystHyperExpFactor()) + (double)Oritech.CONFIG.catalystBaseSouls());
        }
        return resultingCost;
    }

    public int getDisplayedCost() {
        if (this.inventory.method_5438(0).method_7960() || this.inventory.method_5438(1).method_7960()) {
            return 0;
        }
        class_1799 bookCandidate = this.inventory.method_5438(0);
        if (bookCandidate.method_7909().equals(class_1802.field_8598) && bookCandidate.method_57826(class_9334.field_49643)) {
            class_6880 enchantment = (class_6880)((class_9304)bookCandidate.method_57824(class_9334.field_49643)).method_57534().stream().findFirst().get();
            int maxLevel = ((class_1887)enchantment.comp_349()).method_8183();
            int bookLevel = ((class_9304)bookCandidate.method_57824(class_9334.field_49643)).method_57536(enchantment);
            if (bookLevel != maxLevel) {
                return 0;
            }
            class_1799 inputStack = this.inventory.method_5438(1);
            int toolLevel = inputStack.method_58657().method_57536(enchantment);
            boolean isHyper = toolLevel >= maxLevel;
            return this.getEnchantmentCost((class_1887)enchantment.comp_349(), toolLevel + 1, isHyper);
        }
        return 0;
    }

    private boolean canProceed() {
        if (this.inventory.method_5438(0).method_7960() || this.inventory.method_5438(1).method_7960()) {
            return false;
        }
        class_1799 bookCandidate = this.inventory.method_5438(0);
        if (bookCandidate.method_7909().equals(class_1802.field_8598) && bookCandidate.method_57826(class_9334.field_49643)) {
            class_6880 enchantment = (class_6880)((class_9304)bookCandidate.method_57824(class_9334.field_49643)).method_57534().stream().findFirst().get();
            int maxLevel = ((class_1887)enchantment.comp_349()).method_8183();
            int level = ((class_9304)bookCandidate.method_57824(class_9334.field_49643)).method_57536(enchantment);
            if (enchantment.method_40220(TagContent.CATALYST_ENCHANTMENT_BLACKLIST)) {
                return false;
            }
            class_1799 inputStack = this.inventory.method_5438(1);
            int toolLevel = inputStack.method_58657().method_57536(enchantment);
            this.isHyperEnchanting = toolLevel >= maxLevel;
            return level == maxLevel && this.hasEnoughSouls((class_1887)enchantment.comp_349(), toolLevel + 1);
        }
        return false;
    }

    @Override
    public void onSoulIncoming(class_243 source) {
        float distance = (float)source.method_1022(this.field_11867.method_46558());
        ++this.collectedSouls;
        this.networkDirty = true;
        class_243 soulPath = this.field_11867.method_46558().method_1020(source);
        ParticleContent.SoulParticleData animData = new ParticleContent.SoulParticleData(soulPath, (int)EnchantmentCatalystBlockEntity.getSoulTravelDuration(distance));
        ParticleContent.WANDERING_SOUL.spawn(this.field_11863, source.method_1031(0.0, (double)0.7f, 0.0), (Object)animData);
    }

    @Override
    public boolean canAcceptSoul() {
        return this.collectedSouls < this.maxSouls;
    }

    @Override
    public int getComparatorOutput() {
        return this.calculateComparatorLevel();
    }

    private int calculateComparatorLevel() {
        return (int)((float)this.collectedSouls / (float)this.maxSouls * 16.0f);
    }

    private void updateNetwork() {
        NetworkManager.sendBlockHandle(this, new CatalystSyncPacket(this.field_11867, this.collectedSouls, this.progress, this.isHyperEnchanting, this.maxSouls));
    }

    public void saveExtraData(class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        this.updateNetwork();
        return new CatalystScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return this.energyStorage;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 35), new ScreenProvider.GuiSlot(1, 75, 35));
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 7, 18, 71);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 4, state -> {
            if (state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                return state.setAndContinue(EMPTY);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("stabilized", STABILIZED).triggerableAnim("idle", IDLE).triggerableAnim("unstable", UNSTABLE).triggerableAnim("empty", EMPTY).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    private void updateAnimation() {
        String targetAnim;
        String string = targetAnim = this.isEmpty() ? "empty" : "idle";
        if (this.maxSouls > this.baseSoulCapacity) {
            targetAnim = "stabilized";
        }
        if (this.unstableTicks > 0) {
            targetAnim = "unstable";
        }
        if (!targetAnim.equals(this.lastAnimation)) {
            this.triggerAnim("machine", targetAnim);
            this.lastAnimation = targetAnim;
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return (float)this.progress / 20.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.CATALYST_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showEnergy() {
        return true;
    }

    public static void receiveUpdatePacket(CatalystSyncPacket packet, class_1937 world, class_5455 dynamicRegistryManager) {
        class_2586 class_25862 = world.method_8321(packet.position);
        if (class_25862 instanceof EnchantmentCatalystBlockEntity) {
            EnchantmentCatalystBlockEntity catalystBlock = (EnchantmentCatalystBlockEntity)class_25862;
            catalystBlock.isHyperEnchanting = packet.isHyperEnchanting();
            catalystBlock.progress = packet.progress();
            catalystBlock.collectedSouls = packet.storedSouls();
            catalystBlock.maxSouls = packet.maxSouls();
        }
    }

    public record CatalystSyncPacket(class_2338 position, int storedSouls, int progress, boolean isHyperEnchanting, int maxSouls) implements class_8710
    {
        public static final class_8710.class_9154<CatalystSyncPacket> PACKET_ID = new class_8710.class_9154(Oritech.id("catalyst"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

