/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.networking;

import com.mojang.serialization.Codec;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import rearth.oritech.Oritech;
import rearth.oritech.OritechPlatform;
import rearth.oritech.api.networking.AdditionalNetworkingProvider;
import rearth.oritech.api.networking.NetworkedEventHandler;
import rearth.oritech.api.networking.ReflectiveCodecBuilder;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;
import rearth.oritech.api.networking.WorldPacketCodec;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.addons.InventoryProxyAddonBlockEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.block.entity.arcane.EnchanterBlockEntity;
import rearth.oritech.block.entity.arcane.EnchantmentCatalystBlockEntity;
import rearth.oritech.block.entity.arcane.SpawnerControllerBlockEntity;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.block.entity.interaction.ShrinkerBlockEntity;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.block.entity.pipes.ItemPipeInterfaceEntity;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.item.tools.PortableLaserItem;
import rearth.oritech.item.tools.armor.JetpackItem;

public class NetworkManager {
    private static final Map<Type, class_9139<? extends ByteBuf, ?>> AUTO_CODECS = new HashMap();
    private static final Map<Integer, List<Field>> CACHED_FIELDS = new HashMap<Integer, List<Field>>();
    public static Codec<FluidStack> FLUID_STACK_CODEC;
    public static class_9139<class_9129, FluidStack> FLUID_STACK_STREAM_CODEC;
    public static class_9139<class_9129, class_2680> SIMPLE_BLOCK_STATE_PACKET_CODEC;
    public static class_9139<class_9129, Vector2i> VEC2I_PACKED_CODEC;
    public static class_9139<class_9129, class_243> VEC3D_PACKET_CODEC;

    public static void sendBlockHandle(class_2586 blockEntity, class_8710 message) {
        OritechPlatform.INSTANCE.sendBlockHandle(blockEntity, message);
    }

    public static void sendPlayerHandle(class_8710 message, class_3222 player) {
        OritechPlatform.INSTANCE.sendPlayerHandle(message, player);
    }

    public static void sendToServer(class_8710 message) {
        OritechPlatform.INSTANCE.sendToServer(message);
    }

    public static <T extends class_8710> void registerToClient(class_8710.class_9154<T> id, class_9139<class_9129, T> packetCodec, TriConsumer<T, class_1937, class_5455> consumer) {
        OritechPlatform.INSTANCE.registerToClient(id, packetCodec, consumer);
    }

    public static <T extends class_8710> void registerToServer(class_8710.class_9154<T> id, class_9139<class_9129, T> packetCodec, TriConsumer<T, class_1657, class_5455> consumer) {
        OritechPlatform.INSTANCE.registerToServer(id, packetCodec, consumer);
    }

    public static void registerDefaultCodecs() {
        NetworkManager.registerCodec(class_9135.field_49675, new Type[]{Integer.class, Integer.TYPE});
        NetworkManager.registerCodec(class_9135.field_48551, new Type[]{Long.class, Long.TYPE});
        NetworkManager.registerCodec(class_9135.field_48552, new Type[]{Float.class, Float.TYPE});
        NetworkManager.registerCodec(class_9135.field_48547, new Type[]{Boolean.class, Boolean.TYPE});
        NetworkManager.registerCodec(class_9135.field_48553, new Type[]{Double.class, Double.TYPE});
        NetworkManager.registerCodec(class_9135.field_48548, new Type[]{Byte.class, Byte.TYPE});
        NetworkManager.registerCodec(class_9135.field_48549, new Type[]{Short.class, Short.TYPE});
        NetworkManager.registerCodec(class_9135.field_48554, new Type[]{String.class});
        NetworkManager.registerCodec(class_2960.field_48267, new Type[]{class_2960.class});
        NetworkManager.registerCodec(class_2338.field_48404, new Type[]{class_2338.class});
        NetworkManager.registerCodec(class_1799.field_49268, new Type[]{class_1799.class});
        NetworkManager.registerCodec(VEC2I_PACKED_CODEC, new Type[]{Vector2i.class});
        NetworkManager.registerCodec(VEC3D_PACKET_CODEC, new Type[]{class_243.class});
        NetworkManager.registerCodec(SIMPLE_BLOCK_STATE_PACKET_CODEC, new Type[]{class_2680.class});
        NetworkManager.registerCodec(FLUID_STACK_STREAM_CODEC, new Type[]{FluidStack.class});
        NetworkManager.registerCodec(ItemFilterBlockEntity.FilterData.PACKET_CODEC, new Type[]{ItemFilterBlockEntity.FilterData.class});
        NetworkManager.registerCodec(OritechRecipeType.PACKET_CODEC, new Type[]{OritechRecipe.class});
        NetworkManager.registerCodec(LaserArmBlockEntity.LASER_TARGET_PACKET_CODEC, new Type[]{class_1309.class});
        NetworkManager.registerCodec(AugmentApplicationEntity.ResearchState.PACKET_CODEC, new Type[]{AugmentApplicationEntity.ResearchState.class});
    }

    public static <T> void registerCodec(class_9139<? extends ByteBuf, T> codec, Type ... classes) {
        for (Type clazz : classes) {
            AUTO_CODECS.put(clazz, codec);
        }
    }

    public static void init() {
        NetworkManager.registerDefaultCodecs();
        NetworkManager.registerToServer(ItemFilterBlockEntity.ItemFilterPayload.FILTER_PACKET_ID, ItemFilterBlockEntity.ItemFilterPayload.PACKET_CODEC, ItemFilterBlockEntity::handleClientUpdate);
        NetworkManager.registerToServer(EnchanterBlockEntity.SelectEnchantingPacket.PACKET_ID, NetworkManager.getAutoCodec(EnchanterBlockEntity.SelectEnchantingPacket.class), EnchanterBlockEntity::receiveEnchantmentSelection);
        NetworkManager.registerToServer(RedstoneAddonBlockEntity.RedstoneAddonServerUpdate.PACKET_ID, NetworkManager.getAutoCodec(RedstoneAddonBlockEntity.RedstoneAddonServerUpdate.class), RedstoneAddonBlockEntity::receiveOnServer);
        NetworkManager.registerToServer(PortableLaserItem.LaserPlayerUsePacket.PACKET_ID, NetworkManager.getAutoCodec(PortableLaserItem.LaserPlayerUsePacket.class), PortableLaserItem::receiveUsePacket);
        NetworkManager.registerToServer(MachineBlockEntity.InventoryInputModeSelectorPacket.PACKET_ID, NetworkManager.getAutoCodec(MachineBlockEntity.InventoryInputModeSelectorPacket.class), MachineBlockEntity::receiveCycleModePacket);
        NetworkManager.registerToServer(InventoryProxyAddonBlockEntity.InventoryProxySlotSelectorPacket.PACKET_ID, NetworkManager.getAutoCodec(InventoryProxyAddonBlockEntity.InventoryProxySlotSelectorPacket.class), InventoryProxyAddonBlockEntity::receiveSlotSelection);
        NetworkManager.registerToServer(JetpackItem.JetpackUsageUpdatePacket.PACKET_ID, NetworkManager.getAutoCodec(JetpackItem.JetpackUsageUpdatePacket.class), JetpackItem::receiveUsagePacket);
        NetworkManager.registerToServer(PlayerAugments.AugmentInstallTriggerPacket.PACKET_ID, NetworkManager.getAutoCodec(PlayerAugments.AugmentInstallTriggerPacket.class), PlayerAugments::receiveInstallTrigger);
        NetworkManager.registerToServer(PlayerAugments.LoadPlayerAugmentsToMachinePacket.PACKET_ID, NetworkManager.getAutoCodec(PlayerAugments.LoadPlayerAugmentsToMachinePacket.class), PlayerAugments::receivePlayerLoadMachine);
        NetworkManager.registerToServer(PlayerAugments.OpenAugmentScreenPacket.PACKET_ID, NetworkManager.getAutoCodec(PlayerAugments.OpenAugmentScreenPacket.class), PlayerAugments::receiveOpenAugmentScreen);
        NetworkManager.registerToServer(PlayerAugments.AugmentPlayerTogglePacket.PACKET_ID, NetworkManager.getAutoCodec(PlayerAugments.AugmentPlayerTogglePacket.class), PlayerAugments::receiveToggleAugment);
        NetworkManager.registerToServer(ShrinkerBlockEntity.ShrinkerPlayerUsePacket.PACKET_ID, NetworkManager.getAutoCodec(ShrinkerBlockEntity.ShrinkerPlayerUsePacket.class), ShrinkerBlockEntity::onPlayerUse);
        NetworkManager.registerToClient(MessagePayload.GENERIC_PACKET_ID, MessagePayload.PACKET_CODEC, NetworkManager::receiveMessage);
        NetworkManager.registerToClient(ItemPipeInterfaceEntity.RenderStackData.PIPE_ITEMS_ID, NetworkManager.getAutoCodec(ItemPipeInterfaceEntity.RenderStackData.class), ItemPipeInterfaceEntity::receiveVisualItemsPacket);
        NetworkManager.registerToClient(EnchantmentCatalystBlockEntity.CatalystSyncPacket.PACKET_ID, NetworkManager.getAutoCodec(EnchantmentCatalystBlockEntity.CatalystSyncPacket.class), EnchantmentCatalystBlockEntity::receiveUpdatePacket);
        NetworkManager.registerToClient(SpawnerControllerBlockEntity.SpawnerSyncPacket.PACKET_ID, NetworkManager.getAutoCodec(SpawnerControllerBlockEntity.SpawnerSyncPacket.class), SpawnerControllerBlockEntity::receiveUpdatePacket);
        NetworkManager.registerToClient(RedstoneAddonBlockEntity.RedstoneAddonClientUpdate.PACKET_ID, NetworkManager.getAutoCodec(RedstoneAddonBlockEntity.RedstoneAddonClientUpdate.class), RedstoneAddonBlockEntity::receiveOnClient);
        NetworkManager.registerToClient(AcceleratorControllerBlockEntity.ParticleRenderTrail.PACKET_ID, NetworkManager.getAutoCodec(AcceleratorControllerBlockEntity.ParticleRenderTrail.class), AcceleratorControllerBlockEntity::receiveTrail);
        NetworkManager.registerToClient(AcceleratorControllerBlockEntity.LastEventPacket.PACKET_ID, NetworkManager.getAutoCodec(AcceleratorControllerBlockEntity.LastEventPacket.class), AcceleratorControllerBlockEntity::receiveEvent);
    }

    public static void receiveMessage(MessagePayload message, class_1937 world, class_5455 registryAccess) {
        class_9129 receivedBuf = new class_9129(Unpooled.wrappedBuffer((byte[])message.message), registryAccess);
        class_2586 receiverEntity = world.method_8321(message.pos);
        class_2591 receiverType = (class_2591)registryAccess.method_30530(class_7924.field_41255).method_10223(message.targetEntityType);
        if (receiverEntity != null && receiverType != null && receiverType.equals(receiverEntity.method_11017())) {
            NetworkManager.decodeFields(receiverEntity, message.syncType, (ByteBuf)receivedBuf, world);
            if (receiverEntity instanceof NetworkedEventHandler) {
                NetworkedEventHandler networkedBlock = (NetworkedEventHandler)receiverEntity;
                networkedBlock.onNetworkUpdated();
            }
        } else {
            Oritech.LOGGER.debug("Unable to start decoding for block entity type {} at {}. Target Mismatch!", (Object)receiverType, (Object)message.pos);
        }
    }

    public static int encodeFields(Object target, SyncType type, ByteBuf byteBuf, @Nullable class_1937 world) {
        List<Field> fields = NetworkManager.getCachedFields(target, type);
        int encodedCount = 0;
        for (Field field : fields) {
            try {
                if (UpdatableField.class.isAssignableFrom(field.getType())) {
                    Object codec;
                    UpdatableField fieldInstance = (UpdatableField)field.get(target);
                    boolean deltaOnly = fieldInstance.useDeltaOnly(type);
                    UpdatableField dataToSend = deltaOnly ? fieldInstance.getDeltaData() : fieldInstance;
                    Object object = codec = deltaOnly ? fieldInstance.getDeltaCodec() : fieldInstance.getFullCodec();
                    if (codec instanceof WorldPacketCodec) {
                        WorldPacketCodec worldPacketCodec = (WorldPacketCodec)codec;
                        worldPacketCodec.encode(byteBuf, dataToSend, world);
                    } else {
                        codec.encode((Object)byteBuf, (Object)dataToSend);
                    }
                } else {
                    class_9139 codec = NetworkManager.getAutoCodec(field);
                    Object value = field.get(target);
                    if (codec instanceof WorldPacketCodec) {
                        WorldPacketCodec worldPacketCodec = (WorldPacketCodec)codec;
                        worldPacketCodec.encode(byteBuf, value, world);
                    } else {
                        codec.encode((Object)byteBuf, value);
                    }
                }
                ++encodedCount;
            }
            catch (Exception ex) {
                Oritech.LOGGER.warn("failed to encode field: {}", (Object)field.getName(), (Object)ex);
            }
        }
        return encodedCount;
    }

    public static void decodeFields(Object target, SyncType type, ByteBuf byteBuf, class_1937 world) {
        List<Field> fields = NetworkManager.getCachedFields(target, type);
        for (Field field : fields) {
            try {
                Object value;
                if (UpdatableField.class.isAssignableFrom(field.getType())) {
                    Object value2;
                    Object codec;
                    UpdatableField fieldInstance = (UpdatableField)field.get(target);
                    boolean deltaOnly = fieldInstance.useDeltaOnly(type);
                    Object object = codec = deltaOnly ? fieldInstance.getDeltaCodec() : fieldInstance.getFullCodec();
                    if (codec instanceof WorldPacketCodec) {
                        WorldPacketCodec worldPacketCodec = (WorldPacketCodec)codec;
                        value2 = worldPacketCodec.decode(byteBuf, world);
                    } else {
                        value2 = codec.decode((Object)byteBuf);
                    }
                    if (deltaOnly) {
                        fieldInstance.handleDeltaUpdate(value2);
                        continue;
                    }
                    fieldInstance.handleFullUpdate(value2);
                    continue;
                }
                class_9139 codec = NetworkManager.getAutoCodec(field);
                if (codec instanceof WorldPacketCodec) {
                    WorldPacketCodec worldPacketCodec = (WorldPacketCodec)codec;
                    value = worldPacketCodec.decode(byteBuf, world);
                } else {
                    value = codec.decode((Object)byteBuf);
                }
                field.set(target, value);
            }
            catch (Exception ex) {
                Oritech.LOGGER.warn("failed to decode field: {}", (Object)field.getName(), (Object)ex);
            }
        }
    }

    @NotNull
    private static List<Field> getCachedFields(Object target, SyncType type) {
        int key = target.getClass().hashCode() + type.hashCode();
        return CACHED_FIELDS.computeIfAbsent(key, elem -> NetworkManager.getSyncFields(target, type));
    }

    @NotNull
    private static List<Field> getSyncFields(Object target, SyncType type) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(target.getClass().getDeclaredFields()));
        for (Class<?> superClass = target.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        fields.stream().filter(field -> NetworkManager.hasSyncType(field.getAnnotation(SyncField.class), type)).forEachOrdered(field -> {
            field.setAccessible(true);
            filteredFields.add((Field)field);
        });
        if (target instanceof AdditionalNetworkingProvider) {
            AdditionalNetworkingProvider additionalNetworkingProvider = (AdditionalNetworkingProvider)target;
            List<Field> addedFields = additionalNetworkingProvider.additionalSyncedFields(type);
            addedFields.forEach(field -> {
                field.setAccessible(true);
                filteredFields.add((Field)field);
            });
        }
        return filteredFields;
    }

    public static class_9139 getAutoCodec(Class<?> type) {
        if (!AUTO_CODECS.containsKey(type)) {
            if (type.isRecord()) {
                Oritech.LOGGER.debug("creating reflective codec for: " + String.valueOf(type));
                class_9139<class_9129, ?> computedCodec = ReflectiveCodecBuilder.create(type);
                AUTO_CODECS.put(type, computedCodec);
                return computedCodec;
            }
            if (type.isEnum()) {
                Oritech.LOGGER.debug("creating reflective enum codec for: " + String.valueOf(type));
                class_9139<class_9129, ?> computedCodec = ReflectiveCodecBuilder.createForEnum(type);
                AUTO_CODECS.put(type, computedCodec);
                return computedCodec;
            }
        }
        if (!AUTO_CODECS.containsKey(type)) {
            Oritech.LOGGER.error("No codec defined for: {}", type);
        }
        return AUTO_CODECS.get(type);
    }

    public static class_9139 getAutoCodec(Field field) {
        Optional<Type> listType = NetworkManager.getListType(field.getGenericType());
        if (listType.isPresent()) {
            class_9139 listTypeCodec = NetworkManager.getAutoCodec((Class)listType.get());
            return listTypeCodec.method_56433(class_9135.method_56363());
        }
        Optional<Type> setType = NetworkManager.getSetType(field.getGenericType());
        if (setType.isPresent()) {
            class_9139 setTypeCodec = NetworkManager.getAutoCodec((Class)setType.get());
            return setTypeCodec.method_56433(NetworkManager.toSet());
        }
        Optional<class_3545<Type, Type>> mapType = NetworkManager.getMapType(field.getGenericType());
        if (mapType.isPresent()) {
            class_9139 keyCodec = NetworkManager.getAutoCodec((Class)mapType.get().method_15442());
            class_9139 valueCodec = NetworkManager.getAutoCodec((Class)mapType.get().method_15441());
            if (keyCodec == null) {
                Oritech.LOGGER.error("Unable to get codec for map key type: {}", field.getType());
            }
            if (valueCodec == null) {
                Oritech.LOGGER.error("Unable to get codec for map value type: {}", field.getType());
            }
            return class_9135.method_56377(HashMap::new, (class_9139)keyCodec, (class_9139)valueCodec);
        }
        return NetworkManager.getAutoCodec(field.getType());
    }

    public static Optional<Type> getListType(Type type) {
        ParameterizedType pType;
        Class rawType;
        if (type instanceof ParameterizedType && (rawType = (Class)(pType = (ParameterizedType)type).getRawType()) instanceof Class && List.class.isAssignableFrom(rawType)) {
            return Optional.of(pType.getActualTypeArguments()[0]);
        }
        return Optional.empty();
    }

    public static Optional<Type> getSetType(Type type) {
        ParameterizedType pType;
        Class rawType;
        if (type instanceof ParameterizedType && (rawType = (Class)(pType = (ParameterizedType)type).getRawType()) instanceof Class && Set.class.isAssignableFrom(rawType)) {
            return Optional.of(pType.getActualTypeArguments()[0]);
        }
        return Optional.empty();
    }

    public static Optional<class_3545<Type, Type>> getMapType(Type type) {
        ParameterizedType pType;
        Class rawType;
        if (type instanceof ParameterizedType && (rawType = (Class)(pType = (ParameterizedType)type).getRawType()) instanceof Class && Map.class.isAssignableFrom(rawType)) {
            Type[] typeArgs = pType.getActualTypeArguments();
            return Optional.of(new class_3545((Object)typeArgs[0], (Object)typeArgs[1]));
        }
        return Optional.empty();
    }

    private static boolean hasSyncType(SyncField annotation, SyncType type) {
        if (annotation == null) {
            return false;
        }
        for (SyncType value : annotation.value()) {
            if (!value.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    static <B extends ByteBuf, V> class_9139.class_9140<B, V, Set<V>> toSet() {
        return codec -> class_9135.method_56376(HashSet::new, (class_9139)codec);
    }

    public static <K, V> class_9139<class_9129, HashMap<K, V>> createMapCodec(Class<K> keyType, Class<V> valueType) {
        return class_9135.method_56377(HashMap::new, (class_9139)NetworkManager.getAutoCodec(keyType), (class_9139)NetworkManager.getAutoCodec(valueType));
    }

    static {
        SIMPLE_BLOCK_STATE_PACKET_CODEC = new class_9139<class_9129, class_2680>(){

            public class_2680 decode(class_9129 buf) {
                return ((class_2248)class_7923.field_41175.method_10223((class_2960)class_2960.field_48267.decode((Object)buf))).method_9564();
            }

            public void encode(class_9129 buf, class_2680 value) {
                class_2960.field_48267.encode((Object)buf, (Object)class_7923.field_41175.method_10221((Object)value.method_26204()));
            }
        };
        VEC2I_PACKED_CODEC = class_9139.method_56435((class_9139)class_9135.field_49675, Vector2i::x, (class_9139)class_9135.field_49675, Vector2i::y, Vector2i::new);
        VEC3D_PACKET_CODEC = new class_9139<class_9129, class_243>(){

            public class_243 decode(class_9129 buf) {
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                return new class_243(x, y, z);
            }

            public void encode(class_9129 buf, class_243 value) {
                buf.method_52940(value.field_1352);
                buf.method_52940(value.field_1351);
                buf.method_52940(value.field_1350);
            }
        };
    }

    public record MessagePayload(class_2338 pos, class_2960 targetEntityType, SyncType syncType, byte[] message) implements class_8710
    {
        public static final class_8710.class_9154<MessagePayload> GENERIC_PACKET_ID = new class_8710.class_9154(Oritech.id("generic"));
        public static final class_9139<class_9129, MessagePayload> PACKET_CODEC = new class_9139<class_9129, MessagePayload>(){

            public MessagePayload decode(class_9129 buf) {
                return new MessagePayload((class_2338)class_2338.field_48404.decode((Object)buf), (class_2960)class_2960.field_48267.decode((Object)buf), (SyncType)((Object)SyncType.PACKET_CODEC.decode((Object)buf)), (byte[])class_9135.field_48987.decode((Object)buf));
            }

            public void encode(class_9129 buf, MessagePayload value) {
                class_2338.field_48404.encode((Object)buf, (Object)value.pos);
                class_2960.field_48267.encode((Object)buf, (Object)value.targetEntityType);
                SyncType.PACKET_CODEC.encode((Object)buf, (Object)value.syncType);
                class_9135.field_48987.encode((Object)buf, (Object)value.message);
            }
        };

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return GENERIC_PACKET_ID;
        }
    }
}

