package rearth.oritech.util;

import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.client.init.ParticleContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public interface MultiblockMachineController {
    
    List<class_2382> getCorePositions();
    
    class_2350 getFacingForMultiblock();
    
    class_2338 getPosForMultiblock();
    
    class_1937 getWorldForMultiblock();
    
    ArrayList<class_2338> getConnectedCores();
    
    void setCoreQuality(float quality);
    
    float getCoreQuality();
    
    ItemApi.InventoryStorage getInventoryForMultiblock();
    
    EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction);
    
    default void addMultiblockToNbt(class_2487 nbt) {
        
        var posList = new class_2499();
        for (var pos : getConnectedCores()) {
            var posTag = new class_2487();
            posTag.method_10569("x", pos.method_10263());
            posTag.method_10569("y", pos.method_10264());
            posTag.method_10569("z", pos.method_10260());
            posList.add(posTag);
        }
        nbt.method_10566("connectedCores", posList);
        nbt.method_10548("coreQuality", getCoreQuality());
    }
    
    default void loadMultiblockNbtData(class_2487 nbt) {
        
        var posList = nbt.method_10554("connectedCores", class_2520.field_33260);
        var coreBlocksConnected = getConnectedCores();
        
        for (var posTag : posList) {
            var posCompound = (class_2487) posTag;
            var x = posCompound.method_10550("x");
            var y = posCompound.method_10550("y");
            var z = posCompound.method_10550("z");
            var pos = new class_2338(x, y, z);
            coreBlocksConnected.add(pos);
        }
        
        setCoreQuality(nbt.method_10583("coreQuality"));
    }
    
    default Boolean tryPlaceNextCore(class_1657 player) {
        
        var heldStack = player.method_6118(class_1304.field_6173);
        var heldItem = heldStack.method_7909();
        
        if (!(heldItem instanceof class_1747 blockItem)) return false;
        
        if (blockItem.method_7711() instanceof MachineCoreBlock) {
            var nextPosition = this.getNextMissingCore();
            if (nextPosition != null) {
                this.getWorldForMultiblock().method_8501(nextPosition, blockItem.method_7711().method_9564());
                if (!player.method_7337()) {
                    heldStack.method_7934(1);
                    if (heldStack.method_7947() == 0)
                        player.method_6122(class_1268.field_5808, class_1799.field_8037);
                }
                return true;
            }
        }
        return false;
    }
    
    default class_2338 getNextMissingCore() {
        
        var world = getWorldForMultiblock();
        var pos = getPosForMultiblock();
        
        var ownFacing = getFacingForMultiblock();
        var targetMachinePositions = getCorePositions();
        
        for (var targetMachinePosition : targetMachinePositions) {
            var rotatedPos = Geometry.rotatePosition(targetMachinePosition, ownFacing);
            var checkPos = pos.method_10081(rotatedPos);
            var checkState = Objects.requireNonNull(world).method_8320(checkPos);
            
            if (checkState.method_27852(class_2246.field_10124) || checkState.method_26164(class_6862.method_40092(class_7924.field_41254, class_2960.method_60655("minecraft", "replaceable")))) {
                return checkPos;
            }
        }
        
        return null;
    }
    
    default boolean initMultiblock(class_2680 state) {
        
        // check if multiblock is already created, if so cancel
        // call method the get a list of relative positions
        // check all positions if the blocks there extend MachineCoreBlock
        // if so, add them to list of used blocks
        // if not (e.g. block wrong type or air), draw a small particle to indicate the missing position
        // when all blocks are valid, multiblock is active
        // update all multiblocks state to USED=true, write controller position to block state
        
        if (state.method_11654(MultiblockMachine.ASSEMBLED)) return true;
        var world = getWorldForMultiblock();
        var pos = getPosForMultiblock();
        var coreBlocksConnected = getConnectedCores();
        
        var ownFacing = getFacingForMultiblock();
        
        var targetMachinePositions = getCorePositions();
        var coreBlocks = new ArrayList<MultiBlockElement>(targetMachinePositions.size());
        
        var sumCoreQuality = 0f;
        
        for (var targetMachinePosition : targetMachinePositions) {
            var rotatedPos = Geometry.rotatePosition(targetMachinePosition, ownFacing);
            var checkPos = pos.method_10081(rotatedPos);
            var checkState = Objects.requireNonNull(world).method_8320(checkPos);
            
            var blockType = checkState.method_26204();
            if (blockType instanceof MachineCoreBlock coreBlock && !checkState.method_11654(MachineCoreBlock.USED)) {
                coreBlocks.add(new MultiBlockElement(checkState, coreBlock, checkPos));
                sumCoreQuality += coreBlock.getCoreQuality();
            } else {
                highlightBlock(checkPos, world);
            }
        }
        
        if (targetMachinePositions.size() == coreBlocks.size()) {
            // valid
            for (var core : coreBlocks) {
                var newState = core.state.method_11657(MachineCoreBlock.USED, true);
                var coreEntity = (MachineCoreEntity) world.method_8321(core.pos());
                coreEntity.setControllerPos(pos);
                world.method_8501(core.pos, newState);
                coreBlocksConnected.add(core.pos);
            }
            
            var quality = sumCoreQuality / coreBlocks.size();
            setCoreQuality(quality);
            
            Objects.requireNonNull(world).method_8501(pos, state.method_11657(MultiblockMachine.ASSEMBLED, true));
            return true;
        } else {
            // invalid
            return false;
        }
    }
    
    default void onCoreBroken(class_2338 corePos) {
        
        var world = getWorldForMultiblock();
        var pos = getPosForMultiblock();
        var coreBlocksConnected = getConnectedCores();
        
        Objects.requireNonNull(world).method_8501(pos, world.method_8320(pos).method_11657(MultiblockMachine.ASSEMBLED, false));
        
        for (var core : coreBlocksConnected) {
            if (core.equals(corePos)) continue;
            
            var state = world.method_8320(core);
            if (state.method_26204() instanceof MachineCoreBlock) {
                world.method_8501(core, state.method_11657(MachineCoreBlock.USED, false));
            }
        }
        
        coreBlocksConnected.clear();
    }
    
    default void onControllerBroken() {
        
        var world = getWorldForMultiblock();
        var coreBlocksConnected = getConnectedCores();
        
        for (var core : coreBlocksConnected) {
            var state = Objects.requireNonNull(world).method_8320(core);
            if (state.method_26204() instanceof MachineCoreBlock) {
                world.method_8501(core, state.method_11657(MachineCoreBlock.USED, false));
            }
        }
        
        coreBlocksConnected.clear();
    }
    
    private void highlightBlock(class_2338 block, class_1937 world) {
        ParticleContent.HIGHLIGHT_BLOCK.spawn(world, class_243.method_24954(block), null);
    }
    
    // this should be called on the server
    void triggerSetupAnimation();
    
    record MultiBlockElement(class_2680 state, MachineCoreBlock coreBlock, class_2338 pos) {
    }
    
}
