package rearth.oritech.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_8149;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rearth.oritech.util.FakePlayerMarker;


@Mixin(class_1297.class)
public abstract class EntityLaserDropsMixin implements class_8149 {


    @Shadow public abstract boolean isAlive();

    @Inject(
            method = "spawnAtLocation(Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;",
            at = @At(value = "NEW", args = "class=net/minecraft/world/entity/item/ItemEntity"),
            cancellable = true
    )
    @SuppressWarnings("ConstantValue") // this is mixin
    private void oritech$teleportDropsToLaser(class_1799 stack, float offsetY, CallbackInfoReturnable<class_1542> cir) {
        if ((Object) this instanceof class_1309 thiz && thiz.method_49107() instanceof FakePlayerMarker) {
            class_1657 attacker = (class_1657) thiz.method_49107();

            if (!isAlive()) { // only teleport when we are dead, ie were killed by the laser
                attacker.method_7270(stack);
                cir.setReturnValue(null);
            }
        }
    }

    @Mixin(class_1309.class)
    static abstract class LivingEntityMixin extends class_1297 {
        public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
            super(entityType, level);
        }

        @Inject(method = "dropExperience", at = @At(value = "HEAD"), cancellable = true)
        private void oritech$disableXpForLaser(class_1297 attacker, CallbackInfo ci) {
            if (attacker instanceof FakePlayerMarker)
                ci.cancel();
        }
    }

}