package rearth.oritech.block.entity.storage;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.EnergyApi.EnergyStorage;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.UnstableContainerBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.*;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class UnstableContainerBlockEntity extends NetworkedBlockEntity implements ScreenProvider, ExtendedMenuProvider,
                                                                           GeoBlockEntity, MultiblockMachineController, EnergyApi.BlockProvider {
    
    public static final RawAnimation SETUP = RawAnimation.begin().thenPlay("setup").thenPlay("idle");
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    
    public static final Long BASE_CAPACITY = Oritech.CONFIG.unstableContainerBaseCapacity();
    
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList<>();
    
    @SyncField(SyncType.GUI_OPEN)
    public class_2680 capturedBlock = class_2246.field_10124.method_9564();
    @SyncField({SyncType.GUI_OPEN, SyncType.GUI_TICK})
    public float qualityMultiplier = 1f;
    @SyncField({SyncType.GUI_OPEN, SyncType.GUI_TICK})
    public DynamicStatisticEnergyStorage.EnergyStatistics currentStats;
    
    private long age = 0;
    private boolean dropped = false;
    
    // scaling storage
    public final SimpleEnergyStorage laserInputStorage = new SimpleEnergyStorage(100_000_000, 0, 100_000_000);
    
    //own storage
    @SyncField({SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final DynamicStatisticEnergyStorage energyStorage = new DynamicStatisticEnergyStorage(20_000_000L, 20_000_000L, 20_000_000L, this::method_5431);
    
    private final EnergyApi.EnergyStorage outputStorage = new DelegatingEnergyStorage(energyStorage, null) {
        @Override
        public boolean supportsInsertion() {
            return false;
        }
    };
    
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    
    public UnstableContainerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.UNSTABLE_CONTAINER_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        
        age++;
        if (age > 10 && !state.method_11654(UnstableContainerBlock.SETUP_DONE)) {
            world.method_8501(pos, state.method_11657(UnstableContainerBlock.SETUP_DONE, true));
        }
        
        energyStorage.tick((int) world.method_8510());
        
        adjustEnergyStorageSize();
        
        if (energyStorage.amount > 0)
            outputEnergy();
    }
    
    private void adjustEnergyStorageSize() {
        
        var targetMultiplier = 1 + Math.pow((double) laserInputStorage.getAmount() / Oritech.CONFIG.laserArmConfig.energyPerTick(), 2);
        targetMultiplier = Math.min(targetMultiplier, 5_000);
        laserInputStorage.setAmount(0);
        var targetAmount = BASE_CAPACITY * qualityMultiplier * targetMultiplier;
        var currentAmount = energyStorage.getCapacity();
        energyStorage.capacity = (long) class_3532.method_16436(0.005d, currentAmount, targetAmount);
        energyStorage.setMaxInsert((long) targetAmount);
        energyStorage.setMaxExtract((long) targetAmount);
        
        if (energyStorage.capacity < energyStorage.maxInsert * 0.9999) {
            // growing, spawn particles
            ParticleContent.UNSTABLE_CONTAINER_GROWING.spawn(field_11863, field_11867.method_46558(), 2);
        }
        
        if (energyStorage.amount > energyStorage.capacity) {
            energyStorage.amount = energyStorage.capacity;
        }
        
        if (energyStorage.capacity != BASE_CAPACITY * qualityMultiplier)
            energyStorage.update();
        
    }
    
    private void outputEnergy() {
        var positions = List.of(new class_2382(0, -3, 0), new class_2382(0, 2, 0));
        for (var outputPos : positions) {
            var worldPos = field_11867.method_10081(outputPos);
            var candidate = EnergyApi.BLOCK.find(field_11863, worldPos, null);
            if (candidate != null) {
                EnergyApi.transfer(energyStorage, candidate, energyStorage.maxExtract, false);
            }
        }
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        addMultiblockToNbt(nbt);
        var blockId = class_7923.field_41175.method_10221(capturedBlock.method_26204());
        nbt.method_10582("captured", blockId.toString());
        nbt.method_10544("energy_stored", energyStorage.amount);
        nbt.method_10544("energy_capacity", energyStorage.capacity);
        nbt.method_10548("quality", qualityMultiplier);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        loadMultiblockNbtData(nbt);
        energyStorage.amount = nbt.method_10537("energy_stored");
        energyStorage.capacity = nbt.method_10537("energy_capacity");
        energyStorage.capacity = nbt.method_10537("energy_capacity");
        qualityMultiplier = nbt.method_10583("quality");
        
        var blockId = nbt.method_10558("captured");
        if (!blockId.isBlank() && class_7923.field_41175.method_10250(class_2960.method_60654(blockId)))
            capturedBlock = class_7923.field_41175.method_10223(class_2960.method_60654(blockId)).method_9564();
        
    }
    
    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        currentStats = energyStorage.getCurrentStatistics(field_11863.method_8510());
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, 0, state -> {
            if (state.getController().getAnimationState().equals(AnimationController.State.STOPPED)) {
                if (this.method_11010().method_11654(UnstableContainerBlock.SETUP_DONE)) {
                    return state.setAndContinue(IDLE);
                } else {
                    return state.setAndContinue(SETUP);
                }
            }
            return PlayState.CONTINUE;
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()));
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
    
    
    @Override
    public List<class_2382> getCorePositions() {
        return getCoreOffsets();
    }
    
    public static List<class_2382> getCoreOffsets() {
        return List.of(
          new class_2382(-1, -2, -1),
          new class_2382(0, -2, -1),
          new class_2382(1, -2, -1),
          new class_2382(-1, -2, 0),
          new class_2382(0, -2, 0),
          new class_2382(1, -2, 0),
          new class_2382(-1, -2, 1),
          new class_2382(0, -2, 1),
          new class_2382(1, -2, 1),
          new class_2382(-1, -1, -1),
          new class_2382(0, -1, -1),
          new class_2382(1, -1, -1),
          new class_2382(-1, -1, 0),
          new class_2382(0, -1, 0),
          new class_2382(1, -1, 0),
          new class_2382(-1, -1, 1),
          new class_2382(0, -1, 1),
          new class_2382(1, -1, 1),
          new class_2382(-1, 0, -1),
          new class_2382(0, 0, -1),
          new class_2382(1, 0, -1),
          new class_2382(-1, 0, 0),
          new class_2382(1, 0, 0),
          new class_2382(-1, 0, 1),
          new class_2382(0, 0, 1),
          new class_2382(1, 0, 1),
          new class_2382(0, 1, -1),
          new class_2382(-1, 1, 0),
          new class_2382(0, 1, 0),
          new class_2382(1, 1, 0),
          new class_2382(0, 1, 1)
        );
    }
    
    @Override
    public class_2350 getFacingForMultiblock() {
        return class_2350.field_11043;
    }
    
    @Override
    public class_2338 getPosForMultiblock() {
        return field_11867;
    }
    
    @Override
    public class_1937 getWorldForMultiblock() {
        return field_11863;
    }
    
    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return coreBlocksConnected;
    }
    
    @Override
    public void setCoreQuality(float quality) {
    
    }
    
    @Override
    public float getCoreQuality() {
        return 7;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return getEnergyStorage(direction);
    }
    
    @Override
    public void triggerSetupAnimation() {}
    
    @Override
    public void onCoreBroken(class_2338 corePos) {
        onBroken(corePos);
    }
    
    @Override
    public void onControllerBroken() {
        onBroken(field_11867);
    }
    
    private void onBroken(class_2338 eventSource) {
        if (dropped) return;
        dropped = true;
        
        for (var corePos : coreBlocksConnected) {
            if (corePos.equals(eventSource)) continue;
            field_11863.method_8501(corePos, class_2246.field_10124.method_9564());
        }
        
        field_11863.method_8501(field_11867, capturedBlock);
        
        var spawnAt = this.field_11867.method_46558().method_1031(0, 1, 0);
        field_11863.method_8649(new class_1542(field_11863, spawnAt.field_1352, spawnAt.field_1351, spawnAt.field_1350, new class_1799(ItemContent.UNSTABLE_CONTAINER)));
        
    }
    
    public void setCapturedBlock(class_2680 capturedBlock) {
        this.capturedBlock = capturedBlock;
        method_5431();
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        
        if (direction == null) return energyStorage;
        
        if (direction.equals(class_2350.field_11033) || direction.equals(class_2350.field_11036))
            return outputStorage;
        
        return energyStorage;
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of();
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return 0;   // todo
    }
    
    @Override
    public float getDisplayedEnergyTransfer() {
        return energyStorage.maxInsert;
    }
    
    @Override
    public BarConfiguration getEnergyConfiguration() {
        return new BarConfiguration(7, 6, 15, 54 + 18);
    }
    
    @Override
    public float getProgress() {
        return 0;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return new class_1277();
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.STORAGE_SCREEN;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public boolean showProgress() {
        return false;
    }
    
    @Override
    public boolean showExpansionPanel() {
        return false;
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470("");
    }
    
    @Override
    public @Nullable class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }
}
