package rearth.oritech.block.blocks.pipes.item;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.pipes.ItemFilterBlockEntity;
import rearth.oritech.util.Geometry;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2753;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

// how this block works:
// points to block/storage that player was facing when placing (e.g. similar to addons)
// connects via pipes to other nearby inventories
// has a GUI to configure filter options (n amount of slots available, and some buttons to filter based on metadata)
// filter options: whitelist/blacklist, ignore damage, ignore nbt
public class ItemFilterBlock extends class_2248 implements class_2343 {
    
    public static final class_2753 TARGET_DIR = class_2753.method_35305("target_dir");

    private static final class_265[] BOUNDING_SHAPES;
    
    public ItemFilterBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(TARGET_DIR, class_2350.field_11043));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(TARGET_DIR);
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return super.method_9605(ctx).method_11657(TARGET_DIR, ctx.method_8038().method_10153());
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ItemFilterBlockEntity(pos, state);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            var handler = (ExtendedMenuProvider) world.method_8321(pos);
                MenuRegistry.openExtendedMenu((class_3222) player, handler);
        }
        
        return class_1269.field_5812;
    }
    
    @SuppressWarnings("rawtypes")
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        tooltip.add(class_2561.method_43471("tooltip.oritech.item_filter").method_27692(class_124.field_1080));
        super.method_9568(stack, context, tooltip, options);
    }

        @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BOUNDING_SHAPES[state.method_11654(TARGET_DIR).method_10146()];
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return method_9530(state, world, pos, context);
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.field_9236) {
            var entity = (ItemFilterBlockEntity) world.method_8321(pos);
            var stacks = entity.inventory.heldStacks;
            for (var stack : stacks) {
                if (!stack.method_7960()) {
                    var itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack);
                    world.method_8649(itemEntity);
                }
            }
            
            entity.inventory.heldStacks.clear();
            entity.inventory.method_5431();
        }
        
        return super.method_9576(world, pos, state, player);
    }

    static {
        BOUNDING_SHAPES = new class_265[class_2350.values().length];
        for (var facing : class_2350.values()) {
            BOUNDING_SHAPES[facing.ordinal()] = class_259.method_17786(
                Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.25, -0.00375, 0.75, 0.75, 0.125), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0, 0.375, 0.375, 0.125, 0.625, 0.625), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.875, 0.375, 0.625, 1, 0.625), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.875, 0.375, 0.375, 1, 0.625, 0.625), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0, 0.375, 0.625, 0.125, 0.625), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.375, 0.875, 0.625, 0.625, 1), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.1875, -0.03125, 0.5625, 0.8125, 0.1875), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.4375, -0.03125, 0.8125, 0.5625, 0.1875), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.4375, 0.4375, 0.875, 0.5625, 0.5625), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.4375, 0.5625, 0.875, 0.5625), facing, class_2738.field_12475),
                Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.4375, 0.8125, 0.5625, 0.5625, 0.875), facing, class_2738.field_12475));
        }
    }
}
