package rearth.oritech.block.base.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public abstract class ItemEnergyFrameInteractionBlockEntity extends FrameInteractionBlockEntity
  implements ItemApi.BlockProvider, EnergyApi.BlockProvider, ExtendedMenuProvider, ScreenProvider, MachineAddonController, RedstoneAddonBlockEntity.RedstoneControllable {
    
    @SyncField({SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(getDefaultCapacity(), getDefaultInsertRate(), 0, this::method_5431);
    
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(getInventorySize(), this::method_5431);
    
    @SyncField({SyncType.GUI_OPEN})
    private final List<class_2338> connectedAddons = new ArrayList<>();
    @SyncField({SyncType.GUI_OPEN})
    private final List<class_2338> openSlots = new ArrayList<>();
    
    @SyncField({SyncType.GUI_OPEN})
    private BaseAddonData addonData = BaseAddonData.DEFAULT_ADDON_DATA;
    
    public ItemEnergyFrameInteractionBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }
    
    public abstract int getMoveEnergyUsage();
    
    public abstract int getOperationEnergyUsage();
    
    @Override
    protected boolean canProgress() {
        return !disabledViaRedstone &&
                 energyStorage.amount >= getMoveEnergyUsage() * getBaseAddonData().efficiency() * (1 / getBaseAddonData().speed()) &&
                 energyStorage.amount >= getOperationEnergyUsage() * getBaseAddonData().efficiency() * (1 / getBaseAddonData().speed());
    }
    
    @Override
    protected void doProgress(boolean moving) {
        var usedCost = moving ? getMoveEnergyUsage() : getOperationEnergyUsage();
        energyStorage.amount -= (long) (usedCost * getBaseAddonData().efficiency() * (1 / getBaseAddonData().speed()));
    }
    
    @Override
    public void finishBlockWork(class_2338 processed) {
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        energyStorage.amount = nbt.method_10537("energy_stored");
        disabledViaRedstone = nbt.method_10577("oritech.redstone");
        
        loadAddonNbtData(nbt);
        updateEnergyContainer();
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        nbt.method_10544("energy_stored", energyStorage.amount);
        nbt.method_10556("oritech.redstone", disabledViaRedstone);
        writeAddonToNbt(nbt);
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return energyStorage;
    }
    
    
    @Override
    public class_2338 getPosForAddon() {
        return method_11016();
    }
    
    @Override
    public class_1937 getWorldForAddon() {
        return method_10997();
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(field_11867);
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_30163("");
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 50, 11));
    }
    
    public int getInventorySize() {
        return 1;
    }
    
    @Override
    public float getProgress() {
        var maxTime = isMoving() ? getMoveTime() : getWorkTime();
        return (float) getCurrentProgress() / maxTime;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return getOperationEnergyUsage() * getBaseAddonData().efficiency() * (1 / getBaseAddonData().speed());
    }
    
    @Override
    public long getDefaultCapacity() {
        return 100_000;
    }
    
    @Override
    public long getDefaultInsertRate() {
        return 5000;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public float getDisplayedEnergyTransfer() {
        return energyStorage.maxInsert;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return inventory;
    }
    
    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }
    
    @Override
    public float getSpeedMultiplier() {
        return addonData.speed();
    }
    
    public DynamicEnergyStorage getEnergyStorage() {
        return energyStorage;
    }
    
    @Override
    public List<class_2338> getConnectedAddons() {
        return connectedAddons;
    }
    
    @Override
    public List<class_2338> getOpenAddonSlots() {
        return openSlots;
    }
    
    @Override
    public class_2350 getFacingForAddon() {
        return super.getFacing();
    }
    
    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return getEnergyStorage();
    }
    
    @Override
    public BaseAddonData getBaseAddonData() {
        return addonData;
    }
    
    @Override
    public void setBaseAddonData(BaseAddonData data) {
        this.addonData = data;
        this.method_5431();
    }
    
    public boolean isActivelyWorking() {
        return field_11863.method_8510() - lastWorkedAt < 5;
    }
    
    @Override
    public int getComparatorEnergyAmount() {
        return (int) ((energyStorage.amount / (float) energyStorage.capacity) * 15);
    }
    
    @Override
    public int getComparatorSlotAmount(int slot) {
        if (inventory.heldStacks.size() <= slot) return 0;
        
        var stack = inventory.method_5438(slot);
        if (stack.method_7960()) return 0;
        
        return (int) ((stack.method_7947() / (float) stack.method_7914()) * 15);
    }
    
    @Override
    public int getComparatorProgress() {
        return 0;
    }
    
    @Override
    public int getComparatorActiveState() {
        return isActivelyWorking() ? 15 : 0;
    }
    
    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.disabledViaRedstone = isPowered;
    }
    
    @Override
    public int receivedRedstoneSignal() {
        if (disabledViaRedstone) return 15;
        return 0;
    }
    
    @Override
    public String currentRedstoneEffect() {
        if (disabledViaRedstone) return "tooltip.oritech.redstone_disabled";
        return "tooltip.oritech.redstone_enabled";
    }
}
