/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.storage;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.UnstableContainerBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class UnstableContainerBlockEntity
extends NetworkedBlockEntity
implements ScreenProvider,
ExtendedMenuProvider,
GeoBlockEntity,
MultiblockMachineController,
EnergyApi.BlockProvider {
    public static final RawAnimation SETUP = RawAnimation.begin().thenPlay("setup").thenPlay("idle");
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public static final Long BASE_CAPACITY = Oritech.CONFIG.unstableContainerBaseCapacity();
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList();
    @SyncField(value={SyncType.GUI_OPEN})
    public class_2680 capturedBlock = class_2246.field_10124.method_9564();
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    public float qualityMultiplier = 1.0f;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    public DynamicStatisticEnergyStorage.EnergyStatistics currentStats;
    private long age = 0L;
    private boolean dropped = false;
    public final SimpleEnergyStorage laserInputStorage = new SimpleEnergyStorage(100000000L, 0L, 100000000L);
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    protected final DynamicStatisticEnergyStorage energyStorage = new DynamicStatisticEnergyStorage(20000000L, 20000000L, 20000000L, this::method_5431);
    private final EnergyApi.EnergyStorage outputStorage = new DelegatingEnergyStorage(this, this.energyStorage, null){

        @Override
        public boolean supportsInsertion() {
            return false;
        }
    };
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public UnstableContainerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.UNSTABLE_CONTAINER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        ++this.age;
        if (this.age > 10L && !((Boolean)state.method_11654((class_2769)UnstableContainerBlock.SETUP_DONE)).booleanValue()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)UnstableContainerBlock.SETUP_DONE, (Comparable)Boolean.valueOf(true)));
        }
        this.energyStorage.tick((int)world.method_8510());
        this.adjustEnergyStorageSize();
        if (this.energyStorage.amount > 0L) {
            this.outputEnergy();
        }
    }

    private void adjustEnergyStorageSize() {
        double targetMultiplier = 1.0 + Math.pow((double)this.laserInputStorage.getAmount() / (double)Oritech.CONFIG.laserArmConfig.energyPerTick(), 2.0);
        targetMultiplier = Math.min(targetMultiplier, 5000.0);
        this.laserInputStorage.setAmount(0L);
        double targetAmount = (double)((float)BASE_CAPACITY.longValue() * this.qualityMultiplier) * targetMultiplier;
        long currentAmount = this.energyStorage.getCapacity();
        this.energyStorage.capacity = (long)class_3532.method_16436((double)0.005, (double)currentAmount, (double)targetAmount);
        this.energyStorage.setMaxInsert((long)targetAmount);
        this.energyStorage.setMaxExtract((long)targetAmount);
        if ((double)this.energyStorage.capacity < (double)this.energyStorage.maxInsert * 0.9999) {
            ParticleContent.UNSTABLE_CONTAINER_GROWING.spawn(this.field_11863, this.field_11867.method_46558(), (Object)2);
        }
        if (this.energyStorage.amount > this.energyStorage.capacity) {
            this.energyStorage.amount = this.energyStorage.capacity;
        }
        if ((float)this.energyStorage.capacity != (float)BASE_CAPACITY.longValue() * this.qualityMultiplier) {
            this.energyStorage.update();
        }
    }

    private void outputEnergy() {
        List<class_2382> positions = List.of(new class_2382(0, -3, 0), new class_2382(0, 2, 0));
        for (class_2382 outputPos : positions) {
            class_2338 worldPos = this.field_11867.method_10081(outputPos);
            EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.field_11863, worldPos, null);
            if (candidate == null) continue;
            EnergyApi.transfer(this.energyStorage, candidate, this.energyStorage.maxExtract, false);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.addMultiblockToNbt(nbt);
        class_2960 blockId = class_7923.field_41175.method_10221((Object)this.capturedBlock.method_26204());
        nbt.method_10582("captured", blockId.toString());
        nbt.method_10544("energy_stored", this.energyStorage.amount);
        nbt.method_10544("energy_capacity", this.energyStorage.capacity);
        nbt.method_10548("quality", this.qualityMultiplier);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.loadMultiblockNbtData(nbt);
        this.energyStorage.amount = nbt.method_10537("energy_stored");
        this.energyStorage.capacity = nbt.method_10537("energy_capacity");
        this.energyStorage.capacity = nbt.method_10537("energy_capacity");
        this.qualityMultiplier = nbt.method_10583("quality");
        String blockId = nbt.method_10558("captured");
        if (!blockId.isBlank() && class_7923.field_41175.method_10250(class_2960.method_60654((String)blockId))) {
            this.capturedBlock = ((class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockId))).method_9564();
        }
    }

    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        this.currentStats = this.energyStorage.getCurrentStatistics(this.field_11863.method_8510());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 0, state -> {
            if (state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                if (((Boolean)this.method_11010().method_11654((class_2769)UnstableContainerBlock.SETUP_DONE)).booleanValue()) {
                    return state.setAndContinue(IDLE);
                }
                return state.setAndContinue(SETUP);
            }
            return PlayState.CONTINUE;
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return UnstableContainerBlockEntity.getCoreOffsets();
    }

    public static List<class_2382> getCoreOffsets() {
        return List.of(new class_2382(-1, -2, -1), new class_2382(0, -2, -1), new class_2382(1, -2, -1), new class_2382(-1, -2, 0), new class_2382(0, -2, 0), new class_2382(1, -2, 0), new class_2382(-1, -2, 1), new class_2382(0, -2, 1), new class_2382(1, -2, 1), new class_2382(-1, -1, -1), new class_2382(0, -1, -1), new class_2382(1, -1, -1), new class_2382(-1, -1, 0), new class_2382(0, -1, 0), new class_2382(1, -1, 0), new class_2382(-1, -1, 1), new class_2382(0, -1, 1), new class_2382(1, -1, 1), new class_2382(-1, 0, -1), new class_2382(0, 0, -1), new class_2382(1, 0, -1), new class_2382(-1, 0, 0), new class_2382(1, 0, 0), new class_2382(-1, 0, 1), new class_2382(0, 0, 1), new class_2382(1, 0, 1), new class_2382(0, 1, -1), new class_2382(-1, 1, 0), new class_2382(0, 1, 0), new class_2382(1, 1, 0), new class_2382(0, 1, 1));
    }

    @Override
    public class_2350 getFacingForMultiblock() {
        return class_2350.field_11043;
    }

    @Override
    public class_2338 getPosForMultiblock() {
        return this.field_11867;
    }

    @Override
    public class_1937 getWorldForMultiblock() {
        return this.field_11863;
    }

    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
    }

    @Override
    public float getCoreQuality() {
        return 7.0f;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return null;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return this.getEnergyStorage(direction);
    }

    @Override
    public void triggerSetupAnimation() {
    }

    @Override
    public void onCoreBroken(class_2338 corePos) {
        this.onBroken(corePos);
    }

    @Override
    public void onControllerBroken() {
        this.onBroken(this.field_11867);
    }

    private void onBroken(class_2338 eventSource) {
        if (this.dropped) {
            return;
        }
        this.dropped = true;
        for (class_2338 corePos : this.coreBlocksConnected) {
            if (corePos.equals((Object)eventSource)) continue;
            this.field_11863.method_8501(corePos, class_2246.field_10124.method_9564());
        }
        this.field_11863.method_8501(this.field_11867, this.capturedBlock);
        class_243 spawnAt = this.field_11867.method_46558().method_1031(0.0, 1.0, 0.0);
        this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, spawnAt.field_1352, spawnAt.field_1351, spawnAt.field_1350, new class_1799((class_1935)ItemContent.UNSTABLE_CONTAINER)));
    }

    public void setCapturedBlock(class_2680 capturedBlock) {
        this.capturedBlock = capturedBlock;
        this.method_5431();
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        if (direction == null) {
            return this.energyStorage;
        }
        if (direction.equals((Object)class_2350.field_11033) || direction.equals((Object)class_2350.field_11036)) {
            return this.outputStorage;
        }
        return this.energyStorage;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of();
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxInsert;
    }

    @Override
    public ScreenProvider.BarConfiguration getEnergyConfiguration() {
        return new ScreenProvider.BarConfiguration(7, 6, 15, 72);
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public class_1263 getDisplayedInventory() {
        return new class_1277(new class_1799[0]);
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.STORAGE_SCREEN;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    public void saveExtraData(class_2540 buf) {
        this.sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }
}

