package rearth.oritech.item.other;

import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;
import rearth.oritech.util.TooltipHelper;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2561;

public class SmallEnergyStorageBlockItem extends class_1747 implements EnergyApi.ItemProvider {
    
    public SmallEnergyStorageBlockItem(class_2248 block, class_1793 settings) {
        super(block, settings);
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var storedEnergy = stack.method_57825(EnergyApi.ITEM.getEnergyComponent(), 0L);
        
        if (storedEnergy != 0) {
            var text = class_2561.method_43469("tooltip.oritech.energy_stored", TooltipHelper.getEnergyText(storedEnergy));
            tooltip.add(text.method_27692(class_124.field_1065));
        }
        
        super.method_7851(stack, context, tooltip, type);
        
    }
    
    @Override
    public boolean method_31567(class_1799 stack) {
        var contentEmpty = stack.method_57825(EnergyApi.ITEM.getEnergyComponent(), 0L) <= 0;
        return !contentEmpty;
    }
    
    @Override
    public int method_31571(class_1799 stack) {
        return 0xff7007;
    }
    
    @Override
    public int method_31569(class_1799 stack) {
        
        var capacity = Oritech.CONFIG.smallEnergyStorage.energyCapacity();
        var fillAmount = stack.method_57825(EnergyApi.ITEM.getEnergyComponent(), 0L);
        
        return Math.round((fillAmount * 100f / capacity) * field_30889) / 100;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_1799 stack) {
        return new SimpleEnergyItemStorage(Oritech.CONFIG.smallEnergyStorage.maxEnergyInsertion(), Oritech.CONFIG.smallEnergyStorage.maxEnergyExtraction(), Oritech.CONFIG.smallEnergyStorage.energyCapacity(), stack);
    }
}
