package rearth.oritech.init.compat.rei;

import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_8786;
import rearth.oritech.init.recipes.OritechRecipe;

import java.util.List;

// holds the recipe data, which is then utilized by the different categories
public class OritechDisplay implements Display {
    
    public final class_8786<OritechRecipe> entry;
    
    public OritechDisplay(class_8786<OritechRecipe> entry) {
        this.entry = entry;
    }
    
    @Override
    public List<EntryIngredient> getInputEntries() {
        return CollectionUtils.map(entry.comp_1933().getInputs(), EntryIngredients::ofIngredient);
    }
    
    @Override
    public List<EntryIngredient> getOutputEntries() {
        return CollectionUtils.map(entry.comp_1933().getResults(), EntryIngredients::of);
    }
    
    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return CategoryIdentifier.of(entry.comp_1933().getOriType().getIdentifier());
    }
    
    public class_8786<OritechRecipe> getEntry() {
        return entry;
    }
}
