package rearth.oritech.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.platform.Platform;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.*;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.*;
import io.wispforest.owo.ui.util.NinePatchTexture;
import io.wispforest.owo.ui.util.SpriteUtilInvoker;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import rearth.oracle.Oracle;
import rearth.oracle.OracleClient;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.generators.BasicGeneratorEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.client.renderers.LaserArmModel;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.TooltipHelper;

import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2459;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7923;

public class BasicMachineScreen<S extends BasicMachineScreenHandler> extends BaseOwoHandledScreen<FlowLayout, S> {
    
    
    public static final class_2960 BACKGROUND = Oritech.id("textures/gui/modular/gui_base.png");
    public static final class_2960 ITEM_SLOT = Oritech.id("textures/gui/modular/itemslot.png");
    public static final class_2960 GUI_COMPONENTS = Oritech.id("textures/gui/modular/machine_gui_components.png");
    public static final int GRAY_TEXT_COLOR = new Color(0.2f, 0.2f, 0.3f).rgb();
    public static Surface ORITECH_PANEL = (context, component) -> NinePatchTexture.draw(class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel"), context, component);
    public static Surface ORITECH_PANEL_DARK = (context, component) -> NinePatchTexture.draw(class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel_dark"), context, component);
    public static Surface ORITECH_PANEL_ORANGE = (context, component) -> NinePatchTexture.draw(class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel_orange"), context, component);

    public static ButtonComponent.Renderer ORITECH_BUTTON = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        var texture = button.field_22763 ? (button.method_49606() ? class_310.method_1551().field_1729.method_1608() ? class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel_pressed") : class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel_hover") : class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel")) : ButtonComponent.DISABLED_TEXTURE;
        NinePatchTexture.draw(texture, matrices, button.method_46426(), button.method_46427(), button.width(), button.height());
    };
    public static ButtonComponent.Renderer ORITECH_BUTTON_DARK = (matrices, button, delta) -> {
        RenderSystem.enableDepthTest();
        var texture = button.field_22763 ? (button.method_49606() ? class_310.method_1551().field_1729.method_1608() ? class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel_pressed") : class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel_dark_hover") : class_2960.method_60655(Oritech.MOD_ID, "bedrock_panel_dark")) : ButtonComponent.DISABLED_TEXTURE;
        NinePatchTexture.draw(texture, matrices, button.method_46426(), button.method_46427(), button.width(), button.height());
    };
    
    public FlowLayout root;
    protected TextureComponent progress_indicator;
    protected TextureComponent energyIndicator;
    private ButtonComponent cycleInputButton;
    
    private final FluidDisplay genericDisplay;
    private final FluidDisplay steamDisplay;
    private final FluidDisplay waterDisplay;
    protected final LabelComponent steamProductionLabel;
    
    protected static final class FluidDisplay {
        private final BoxComponent fillOverlay;
        private float lastFill;
        private class_3611 lastDrawnFluid;
        protected ColoredSpriteComponent background;
        private final TextureComponent foreGround;
        private final ScreenProvider.BarConfiguration config;
        private final FluidApi.SingleSlotStorage storage;
        
        private FluidDisplay(BoxComponent fillOverlay, float lastFill, class_3611 lastDrawnFluid, ColoredSpriteComponent background, TextureComponent foreGround, ScreenProvider.BarConfiguration config, FluidApi.SingleSlotStorage storage) {
            this.fillOverlay = fillOverlay;
            this.lastFill = lastFill;
            this.lastDrawnFluid = lastDrawnFluid;
            this.background = background;
            this.foreGround = foreGround;
            this.config = config;
            this.storage = storage;
        }
    }
    
    public BasicMachineScreen(S handler, class_1661 inventory, class_2561 title) {
        
        super(handler, inventory, title);
        
        if (handler.mainFluidContainer != null) {
            var config = handler.screenData.getFluidConfiguration();
            genericDisplay = initFluidDisplay(handler.mainFluidContainer, config);
        } else {
            genericDisplay = null;
        }
        
        if (handler.steamStorage != null) {
            var config = getBoilerInConfig();
            waterDisplay = initFluidDisplay(handler.waterStorage, config);
            
            var configSteam = getBoilerOutConfig();
            steamDisplay = initFluidDisplay(handler.steamStorage, configSteam);
            // the label is then actually added to the screen in the upgradable screen extension
            steamProductionLabel = Components.label(class_2561.method_43469("title.oritech.steam_production", "0"));
            steamProductionLabel.tooltip(class_2561.method_43471("tooltip.oritech.steam_production"));
        } else {
            steamDisplay = null;
            waterDisplay = null;
            steamProductionLabel = null;
        }
        
    }
    
    public ScreenProvider.BarConfiguration getBoilerInConfig() {
        return field_2797.screenData.getEnergyConfiguration();
    }
    
    public ScreenProvider.BarConfiguration getBoilerOutConfig() {
        var config = getBoilerInConfig();
        return new ScreenProvider.BarConfiguration(config.x() + config.width() + 8, config.y(), config.width(), config.height());
    }
    
    public class_2960 getGuiComponents() {
        return GUI_COMPONENTS;
    }
    
    public class_2960 getItemSlot() {
        return ITEM_SLOT;
    }
    
    public class_2960 getBackground() {
        return BACKGROUND;
    }
    
    protected FluidDisplay initFluidDisplay(FluidApi.SingleSlotStorage container, ScreenProvider.BarConfiguration config) {
        var lastFill = 1 - ((float) container.getStack().getAmount() / container.getCapacity());
        var background = createFluidRenderer(container.getStack(), config);

        var fillOverlay = Components.box(Sizing.fixed(config.width()), Sizing.fixed((int) (config.height() * lastFill)));
        fillOverlay.color(new Color(77.6f / 255f, 77.6f / 255f, 77.6f / 255f));
        fillOverlay.fill(true);
        fillOverlay.positioning(Positioning.absolute(config.x(), config.y()));

        var foreGround = Components.texture(getGuiComponents(), 48, 0, 14, 50, 98, 96);
        foreGround.sizing(Sizing.fixed(config.width()), Sizing.fixed(config.height()));
        foreGround.positioning(Positioning.absolute(config.x(), config.y()));

        return new FluidDisplay(fillOverlay, lastFill, container.getStack().getFluid(), background, foreGround, config, container);
    }
    
    public static io.wispforest.owo.ui.core.Component getItemFrame(int x, int y) {
        return Components.texture(ITEM_SLOT, 0, 0, 18, 18, 18, 18).sizing(Sizing.fixed(18)).positioning(Positioning.absolute(x - 1, y - 1));
    }
    
    @Override
    protected @NotNull OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create(this, Containers::verticalFlow);
    }
    
    @Override
    protected void build(FlowLayout rootComponent) {
        this.root = rootComponent;
        
        rootComponent
          .surface(Surface.VANILLA_TRANSLUCENT)
          .horizontalAlignment(HorizontalAlignment.CENTER)
          .verticalAlignment(VerticalAlignment.CENTER);
        
        if (showExtensionPanel()) {
            rootComponent.child(
              Containers.horizontalFlow(Sizing.fixed(176 + 250), Sizing.fixed(166 + 40))
                .child(Containers.horizontalFlow(Sizing.content(), Sizing.content())
                         .child(buildExtensionPanel())
                         .surface(ORITECH_PANEL)
                         .positioning(Positioning.absolute(176 + 117, 30)))
                .positioning(Positioning.relative(50, 50))
                .zIndex(-1)
            );
        }
        
        // equipment panel
        if (field_2797.armorSlots != null) {
            rootComponent.child(
              Containers.horizontalFlow(Sizing.fixed(176 + 250), Sizing.fixed(166 + 40))
                .child(Containers.horizontalFlow(Sizing.content(), Sizing.content())
                         .child(buildEquipmentPanel())
                         .surface(ORITECH_PANEL)
                         .positioning(Positioning.absolute(176 - 80, 30)))
                .positioning(Positioning.relative(50, 50))
                .zIndex(-1)
            );
        }
        
        // show oracle lib help button
        if (Oritech.CONFIG.enableHelpButton()) {
            var hasOracleLib = Platform.isModLoaded("oracle_index");
            Optional<class_2960> linkTarget = hasOracleLib ? getHelpBookLink() : Optional.empty();
            var oracleButton = Components.button(class_2561.method_43470("?"), elem -> onOracleButtonClick(hasOracleLib, linkTarget));
            oracleButton.renderer(ORITECH_BUTTON_DARK);
            if (hasOracleLib) {
                oracleButton.tooltip(class_2561.method_43471("tooltip.oritech.oracle_available"));
            } else {
                oracleButton.tooltip(class_2561.method_43471("tooltip.oritech.oracle_missing"));
            }
            
            // calculate help button position
            oracleButton.positioning(Positioning.relative(0, 96));
            oracleButton.zIndex(10);
            if (linkTarget.isPresent() || !hasOracleLib) {  // only show button if either lib is not installed, or a link is present
                rootComponent.child(
                  Containers.horizontalFlow(Sizing.fixed(176 + 25), Sizing.fixed(166 + 20))
                    .child(oracleButton)
                    .positioning(Positioning.relative(50, 50)));
            }
        }
        
        rootComponent.child(
          Components.texture(BACKGROUND, 0, 0, 176, 166, 176, 166)
        ).child(
          buildOverlay().positioning(Positioning.relative(50, 50))
        );
    }
    
    public boolean showExtensionPanel() {
        return field_2797.screenData.showExpansionPanel();
    }
    
    @Override
    protected void method_37432() {
        super.method_37432();
        
        if (field_2797.screenData.showEnergy()) {
            if (field_2797.steamStorage != null) {
                updateFluidDisplay(waterDisplay);
                updateFluidDisplay(steamDisplay);
            } else {
                updateEnergyBar();
            }
        }
        
        if (field_2797.screenData.showProgress())
            updateProgressBar();
        
        if (showExtensionPanel())
            updateSettingsButtons();
        
        if (field_2797.mainFluidContainer != null)
            updateFluidDisplay(genericDisplay);
        
        if (steamProductionLabel != null) {
            var productionRate = field_2797.screenData.getDisplayedEnergyUsage() * Oritech.CONFIG.generators.steamEngineData.rfToSteamRatio();
            productionRate = Math.min(this.waterDisplay.storage.getStack().getAmount(), productionRate);
            steamProductionLabel.text(class_2561.method_43469("title.oritech.steam_production", String.format("%.0f", productionRate)));
        }
    }
    
    private void updateProgressBar() {
        var config = field_2797.screenData.getIndicatorConfiguration();
        var progress = field_2797.screenData.getProgress();
        
        
        if (field_2797.blockEntity instanceof MachineBlockEntity machineEntity && (machineEntity.getCurrentRecipe().getTime() > 0 || machineEntity.progress > 0)) {
            
            var progressTicks = machineEntity.progress;
            var recipeDurationTicks = machineEntity.getCurrentRecipe().getTime();
            var effectiveDurationTicks = (int) (recipeDurationTicks * machineEntity.getSpeedMultiplier());
            
            if (machineEntity instanceof UpgradableGeneratorBlockEntity generatorBlock) {
                if (recipeDurationTicks <= 0)
                    recipeDurationTicks = (int) (generatorBlock.currentMaxBurnTime / generatorBlock.getSpeedMultiplier() * generatorBlock.getEfficiencyMultiplier());
                effectiveDurationTicks = generatorBlock.currentMaxBurnTime;
            }
            
            if (machineEntity instanceof BasicGeneratorEntity generatorEntity)
                recipeDurationTicks = generatorEntity.currentMaxBurnTime;
            
            
            progress_indicator.tooltip(class_2561.method_43469("tooltip.oritech.progress_indicator", progressTicks, effectiveDurationTicks, recipeDurationTicks));
        }
        
        
        if (config.horizontal()) {
            progress_indicator.visibleArea(PositionedRectangle.of(0, 0, (int) (config.width() * progress), config.height()));
        } else {
            progress_indicator.visibleArea(PositionedRectangle.of(0, 0, config.width(), (int) (config.height() * progress)));
        }
    }
    
    protected void updateEnergyBar() {
        
        var capacity = field_2797.energyStorage.getCapacity();
        var amount = field_2797.energyStorage.getAmount();
        
        var fillAmount = (float) amount / capacity;
        var tooltipText = getEnergyTooltip(amount, capacity, (long) field_2797.screenData.getDisplayedEnergyUsage(), (long) field_2797.screenData.getDisplayedEnergyTransfer());
        
        energyIndicator.tooltip(tooltipText);
        energyIndicator.visibleArea(PositionedRectangle.of(0, 96 - ((int) (96 * (fillAmount))), 24, (int) (96 * fillAmount)));
    }
    
    public static class_2561 getEnergyTooltip(long amount, long max, long showedUsage, long showedTransfer) {
        var percentage = (float) amount / max;
        var energyFill = String.format("%.1f", percentage * 100);
        var storedAmount = TooltipHelper.getEnergyText(amount);
        var usageText = TooltipHelper.getEnergyText(showedUsage);
        var maxAmount = TooltipHelper.getEnergyText(max);
        var transfer = TooltipHelper.getEnergyText(showedTransfer);
        return class_2561.method_43469("tooltip.oritech.energy_usage", storedAmount, maxAmount, energyFill, usageText, transfer);
    }
    
    public void updateSettingsButtons() {
        
        var activeMode = field_2797.screenData.getInventoryInputMode();
        var modeName = activeMode.name().toLowerCase();
        
        if (activeMode.equals(InventoryInputMode.SIDED) && field_2797.blockEntity instanceof MachineBlockEntity machineBlock) {
            var tooltip = class_2561.method_43471("tooltip.%s.input_mode_%s".formatted(Oritech.MOD_ID, modeName));
            var assignment = machineBlock.getSlotAssignments();
            for (var direction : class_2350.values()) {
                var key = "tooltip.oritech.mode_sided_slot_number";
                if (direction.equals(class_2350.field_11033))
                    key = "tooltip.oritech.mode_sided_bottom";
                if (direction.equals(class_2350.field_11036))
                    key = "tooltip.oritech.mode_sided_top";
                
                var horizontalOrdinal = 0;
                if (direction.equals(class_2350.field_11034)) horizontalOrdinal = 1;
                if (direction.equals(class_2350.field_11035)) horizontalOrdinal = 2;
                if (direction.equals(class_2350.field_11039)) horizontalOrdinal = 3;
                var inputSlotIndex = assignment.inputStart() + horizontalOrdinal % assignment.inputCount();
                
                tooltip = tooltip.method_10852(class_2561.method_43469(key, StringUtils.capitalize(direction.toString()), inputSlotIndex));
            }
            cycleInputButton.tooltip(tooltip);
        } else {
            cycleInputButton.tooltip(class_2561.method_43471("tooltip.%s.input_mode_%s".formatted(Oritech.MOD_ID, modeName)));
        }
        cycleInputButton.method_25355(class_2561.method_43471("button.%s.input_mode_%s".formatted(Oritech.MOD_ID, modeName)).method_54663(GRAY_TEXT_COLOR));
        cycleInputButton.method_25355(class_2561.method_43471("button.%s.input_mode_%s".formatted(Oritech.MOD_ID, modeName)).method_54663(GRAY_TEXT_COLOR));
        
    }
    
    private io.wispforest.owo.ui.core.Component buildExtensionPanel() {
        
        var container = Containers.verticalFlow(Sizing.content(), Sizing.content());
        container.surface(Surface.PANEL_INSET);
        container.horizontalAlignment(HorizontalAlignment.CENTER);
        
        container.padding(Insets.of(1, 4, 1, 1));
        container.margins(Insets.of(7));
        
        addExtensionComponents(container);
        updateSettingsButtons();
        
        return container;
    }
    
    private io.wispforest.owo.ui.core.Component buildEquipmentPanel() {
        
        var container = Containers.verticalFlow(Sizing.content(), Sizing.content());
        container.surface(Surface.PANEL_INSET);
        container.horizontalAlignment(HorizontalAlignment.CENTER);
        
        container.padding(Insets.of(2));
        container.margins(Insets.of(6));
        
        for (int i = field_2797.armorSlots.size() - 1; i >= 0; i--) {
            var slotId = field_2797.armorSlots.get(i);
            
            var slotContainer = Containers.horizontalFlow(Sizing.content(), Sizing.content());
            
            var slotComponent = slotAsComponent(slotId);
            var background = Components.texture(getEquipmentSlotTexture(i), 0, 0, 16, 16, 16, 16);
            
            slotContainer.child(slotComponent);
            slotContainer.child(background.positioning(Positioning.absolute(0, 0)));
            
            container.child(slotContainer.margins(Insets.of(1)));
            
            // separator box
            if (i > 0)
                container.child(Components.box(Sizing.fixed(18), Sizing.fixed(1)).color(new Color(0.8f, 0.8f, 0.8f)));
        }
        
        return container;
    }
    
    private class_2960 getEquipmentSlotTexture(int armorSlot) {
        return switch (armorSlot) {
            case 0 -> class_2960.method_60655("minecraft", "textures/item/empty_armor_slot_boots.png");
            case 1 -> class_2960.method_60655("minecraft", "textures/item/empty_armor_slot_leggings.png");
            case 2 -> class_2960.method_60655("minecraft", "textures/item/empty_armor_slot_chestplate.png");
            case 3 -> class_2960.method_60655("minecraft", "textures/item/empty_armor_slot_helmet.png");
            case 4 -> class_2960.method_60655("minecraft", "textures/item/empty_slot_axe.png");
            default -> null;
        };
        
    }
    
    public void addExtensionComponents(FlowLayout container) {
        
        cycleInputButton = Components.button(class_2561.method_43471("button.oritech.input_mode_fill_matching_recipe").method_54663(GRAY_TEXT_COLOR),
          button -> {
              NetworkManager.sendToServer(new MachineBlockEntity.InventoryInputModeSelectorPacket(field_2797.blockPos));
          });
        cycleInputButton.horizontalSizing(Sizing.fixed(73));
        cycleInputButton.margins(Insets.of(3));
        cycleInputButton.renderer(ORITECH_BUTTON);
        cycleInputButton.textShadow(false);
        
        container.child(Components.label(class_2561.method_43471("title.oritech.details")).margins(Insets.of(3, 1, 1, 1)));
        
        var inputSlots = field_2797.screenData.getGuiSlots().stream().filter(slot -> !slot.output()).count();
        if (field_2797.screenData.inputOptionsEnabled() && inputSlots > 1)
            container.child(cycleInputButton);
        
        for (var label : field_2797.screenData.getExtraExtensionLabels()) {
            container.child(Components.label(label.method_15442()).tooltip(label.method_15441()).margins(Insets.of(3)));
        }
        
        if (field_2797.showRedstoneAddon()) {
            // separator
            container.child(Components.box(Sizing.fixed(73), Sizing.fixed(1))
                              .color(new Color(0.8f, 0.8f, 0.8f))
                              .margins(Insets.of(2)));
            
            // current input state
            var hasRedstone = field_2797.screenData.receivedRedstoneSignal() > 0;
            var statusContainer = Containers.horizontalFlow(Sizing.content(), Sizing.content());
            
            statusContainer.child(Components.block(class_2246.field_10523.method_9564().method_11657(class_2459.field_11446, hasRedstone))
                                    .sizing(Sizing.fixed(20)).margins(Insets.of(-6, -4, -8, -4)));
            statusContainer.child(Components.label(class_2561.method_43469("text.oritech.redstone_power", field_2797.screenData.receivedRedstoneSignal()))
                              .margins(Insets.of(3, 1, 1, 1)));
            
            container.child(statusContainer);
            
            // current input state
            if (!field_2797.screenData.currentRedstoneEffect().isEmpty())
                container.child(Components.label(class_2561.method_43471(field_2797.screenData.currentRedstoneEffect()))
                                  .tooltip(class_2561.method_43471(field_2797.screenData.currentRedstoneEffect() + ".tooltip"))
                                  .margins(Insets.of(3, 3, 1, 1)));
        }
        
    }
    
    private FlowLayout buildOverlay() {
        
        var overlay = Containers.verticalFlow(Sizing.fixed(176), Sizing.fixed(166));
        fillOverlay(overlay);
        
        return overlay;
    }
    
    public void fillOverlay(FlowLayout overlay) {
        
        addTitle(overlay);
        
        if (field_2797.mainFluidContainer != null) {
            addFluidDisplay(overlay, genericDisplay);
            updateFluidDisplay(genericDisplay);
        }
        
        for (var slot : field_2797.screenData.getGuiSlots()) {
            overlay.child(this.slotAsComponent(slot.index()).positioning(Positioning.absolute(slot.x(), slot.y())));
            overlay.child(getItemFrame(slot.x(), slot.y()));
        }
        
        if (field_2797.screenData.showEnergy()) {
            if (field_2797.steamStorage != null) {
                addFluidDisplay(overlay, steamDisplay);
                updateFluidDisplay(steamDisplay);
                addFluidDisplay(overlay, waterDisplay);
                updateFluidDisplay(waterDisplay);
            } else {
                addEnergyBar(overlay);
                updateEnergyBar();
            }
            
            if (field_2797.blockEntity instanceof SteamEngineEntity) {
                addEnergyBar(overlay);
                updateEnergyBar();
            }
        }
        
        if (field_2797.screenData.showProgress()) {
            addProgressArrow(overlay);
            updateProgressBar();
        }
    }
    
    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    private void onOracleButtonClick(boolean enabled, Optional<class_2960> target) {
        if (!enabled || target.isEmpty()) {
            Oritech.LOGGER.info("Oracle Index mod is missing. Install it here: https://www.curseforge.com/minecraft/mc-mods/oracle-index (or from modrinth)");
            return;
        }
        
        OracleClient.openScreen("oritech", target.get(), this);
    }
    
    private Optional<class_2960> getHelpBookLink() {
        
        if (this.field_2797.screenData.getWikiLink().isPresent()) return Optional.of(class_2960.method_60655(Oracle.MOD_ID, "books/oritech/" + field_2797.screenData.getWikiLink().get() + ".mdx"));
        
        var blockItem = this.field_2797.machineBlock.method_26204().method_8389();
        var itemId = class_7923.field_41178.method_10221(blockItem);
        
        if (OracleClient.ITEM_LINKS.containsKey(itemId)) {
            return Optional.of(OracleClient.ITEM_LINKS.get(itemId).linkTarget());
        } else {
            return Optional.empty();
        }
        
    }
    
    public boolean useHighTitle() {
        return field_2797.machineBlock.method_26204().method_9518().toString().length() > 18;
    }
    
    private void addTitle(FlowLayout overlay) {
        var blockTitle = field_2797.machineBlock.method_26204().method_9518();
        var label = Components.label(blockTitle);
        label.color(new Color(64 / 255f, 64 / 255f, 64 / 255f));
        label.zIndex(1);
        
        var blockIcon = Components.item(getTitleIcon());
        blockIcon.sizing(Sizing.fixed(24));
        
        var iconPanel = Containers.horizontalFlow(Sizing.content(0), Sizing.content(0));
        iconPanel.padding(Insets.of(2, 5, 3, 3));
        iconPanel.child(blockIcon);
        iconPanel.surface(ORITECH_PANEL);
        iconPanel.zIndex(50);
        
        var textPanel = Containers.horizontalFlow(Sizing.content(0), Sizing.content(0));
        textPanel.padding(Insets.of(5, 6, 6, 5));
        textPanel.child(label);
        textPanel.surface(ORITECH_PANEL);
        
        var combinedPanel = Containers.horizontalFlow(Sizing.content(), Sizing.content());
        combinedPanel.child(iconPanel);
        combinedPanel.child(textPanel.margins(Insets.of(4, 0, -1, 0)));
        
        var horizontalPos = blockTitle.getString().length() > 15 ? 100 : 65;
        var verticalPos = useHighTitle()? - 25 : - 15;
        
        overlay.child(combinedPanel.positioning(Positioning.relative(horizontalPos, verticalPos)));
        overlay.allowOverflow(true);
        
    }
    
    public class_1799 getTitleIcon() {
        return new class_1799(this.field_2797.blockEntity.method_11010().method_26204());
    }
    
    private void addProgressArrow(FlowLayout panel) {
        
        var config = field_2797.screenData.getIndicatorConfiguration();
        
        var empty = Components.texture(config.empty(), 0, 0, config.width(), config.height(), config.width(), config.height());
        progress_indicator = Components.texture(config.full(), 0, 0, config.width(), config.height(), config.width(), config.height());
        
        panel
          .child(empty.positioning(Positioning.absolute(config.x(), config.y())))
          .child(progress_indicator.positioning(Positioning.absolute(config.x(), config.y())));
    }
    
    protected void addFluidDisplay(FlowLayout panel, FluidDisplay display) {
        panel.child(display.background);
        panel.child(display.fillOverlay);
        panel.child(display.foreGround);
    }
    
    protected void updateFluidDisplay(FluidDisplay display) {
        
        var background = display.background;
        var container = display.storage;
        var config = display.config;
        
        // fluid variant inside has changed
        if (!display.lastDrawnFluid.equals(container.getStack().getFluid())) {
            var parent = background.parent();
            var targetIndex = parent.children().indexOf(background);
            var newFluid = createFluidRenderer(container.getStack(), config);
            parent.removeChild(background);
            ((FlowLayout) parent).child(targetIndex, newFluid);
            background = newFluid;
            display.background = background;
            display.lastDrawnFluid = container.getStack().getFluid();
        }
        
        var fill = 1 - ((float) container.getStack().getAmount() / container.getCapacity());
        
        var targetFill = LaserArmModel.lerp(display.lastFill, fill, 0.15f);
        display.lastFill = targetFill;
        
        display.fillOverlay.verticalSizing(Sizing.fixed((int) (config.height() * targetFill * 0.98f)));
        
        var tooltipText = container.getStack().getAmount() > 0
            ? class_2561.method_43469("tooltip.oritech.fluid_content", container.getStack().getAmount() * 1000 / FluidStackHooks.bucketAmount(), FluidStackHooks.getName(container.getStack()).getString())
            : class_2561.method_43471("tooltip.oritech.fluid_empty");
        background.tooltip(tooltipText);
    }
    
    public static ColoredSpriteComponent createFluidRenderer(FluidStack stack, ScreenProvider.BarConfiguration config) {
        var sprite = FluidStackHooks.getStillTexture(stack);
        var spriteColor = FluidStackHooks.getColor(stack);
        
        var parsedColor = Color.ofArgb(spriteColor);
        var opaqueColor = new Color(parsedColor.red(), parsedColor.green(), parsedColor.blue(), 1f);
        spriteColor = opaqueColor.argb();
        
        return getColoredSpriteComponent(stack, config, sprite, spriteColor);
    }
    
    @NotNull
    private static ColoredSpriteComponent getColoredSpriteComponent(FluidStack stack, ScreenProvider.BarConfiguration config, class_1058 sprite, int spriteColor) {
        var tooltipText = stack.getAmount() > 0
            ? class_2561.method_43469("tooltip.oritech.fluid_content", stack.getAmount() * 1000 / FluidStackHooks.bucketAmount(), FluidStackHooks.getName(stack).toString())
            : class_2561.method_43471("tooltip.oritech.fluid_empty");
        
        var result = new ColoredSpriteComponent(sprite);
        result.widthMultiplier = config.width() / 60f;
        result.color = Color.ofArgb(spriteColor);
        result.sizing(Sizing.fixed(config.width()), Sizing.fixed(config.height()));
        result.positioning(Positioning.absolute(config.x(), config.y()));
        result.tooltip(tooltipText);
        return result;
    }
    
    private void addEnergyBar(FlowLayout panel) {
        
        var config = field_2797.screenData.getEnergyConfiguration();
        var insetSize = 1;
        var tooltipText = class_2561.method_43469("tooltip.oritech.energy_indicator", 10, 50);
        
        var frame = Containers.horizontalFlow(Sizing.fixed(config.width() + insetSize * 2), Sizing.fixed(config.height() + insetSize * 2));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of(insetSize));
        frame.positioning(Positioning.absolute(config.x() - insetSize, config.y() - insetSize));
        panel.child(frame);
        
        var indicator_background = Components.texture(getGuiComponents(), 24, 0, 24, 96, 98, 96);
        indicator_background.sizing(Sizing.fixed(config.width()), Sizing.fixed(config.height()));
        
        energyIndicator = Components.texture(getGuiComponents(), 0, 0, 24, (96), 98, 96);
        energyIndicator.sizing(Sizing.fixed(config.width()), Sizing.fixed(config.height()));
        energyIndicator.positioning(Positioning.absolute(0, 0));
        energyIndicator.tooltip(tooltipText);
        
        frame
          .child(indicator_background)
          .child(energyIndicator);
    }
    
    public static class ColoredSpriteComponent extends SpriteComponent {
        
        public Color color;
        public float widthMultiplier = 1f;
        
        protected ColoredSpriteComponent(class_1058 sprite) {
            super(sprite);
        }
        
        public class_1058 getSprite() {
            return sprite;
        }
        
        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            if (sprite == null) return;
            SpriteUtilInvoker.markSpriteActive(this.sprite);
            drawSprite(this.x, this.y, 0, this.width, this.height, this.sprite, this.color.red(), this.color.green(), this.color.blue(), this.color.alpha(), context.method_51448());
        }
        
        // these 2 methods are copies from drawContext, width slight modifications
        public void drawSprite(int x, int y, int z, int width, int height, class_1058 sprite, float red, float green, float blue, float alpha, class_4587 matrices) {
            
            var uvWidth = sprite.method_4577() - sprite.method_4594();
            var newMax = sprite.method_4594() + uvWidth * widthMultiplier;
            
            this.drawTexturedQuad(sprite.method_45852(), matrices, x, x + width, y, y + height, z, sprite.method_4594(), newMax, sprite.method_4593(), sprite.method_4575(), red, green, blue, alpha);
        }
        
        // direct copy of the method in drawContext, because it can't be called from here due to private access
        private void drawTexturedQuad(class_2960 texture, class_4587 matrices, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha) {
            RenderSystem.setShaderTexture(0, texture);
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.enableBlend();
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22918(matrix4f, (float) x1, (float) y1, (float) z).method_22913(u1, v1).method_22915(red, green, blue, alpha);
            bufferBuilder.method_22918(matrix4f, (float) x1, (float) y2, (float) z).method_22913(u1, v2).method_22915(red, green, blue, alpha);
            bufferBuilder.method_22918(matrix4f, (float) x2, (float) y2, (float) z).method_22913(u2, v2).method_22915(red, green, blue, alpha);
            bufferBuilder.method_22918(matrix4f, (float) x2, (float) y1, (float) z).method_22913(u2, v1).method_22915(red, green, blue, alpha);
            class_286.method_43433(bufferBuilder.method_60800());
            RenderSystem.disableBlend();
        }
        
    }
}
