package rearth.oritech.client.renderers;

import rearth.oritech.Oritech;
import rearth.oritech.block.entity.generators.BigSolarPanelEntity;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import java.util.HashMap;
import net.minecraft.class_3545;

public class SolarPanelModel<T extends BigSolarPanelEntity & GeoAnimatable> extends DefaultedBlockGeoModel<T> {
    
    private final HashMap<Long, class_3545<GeoBone, Float>> renderData = new HashMap<>();
    
    private class_3545<GeoBone, Float> getDataFromCache(long id) {
        return renderData.computeIfAbsent(id, s -> new class_3545<>(getAnimationProcessor().getBone("pivotZ"), 0f));
    }
    
    public SolarPanelModel(String subpath) {
        super(Oritech.id(subpath));
    }
    
    @Override
    public void setCustomAnimations(T solarEntity, long instanceId, AnimationState<T> animationState) {
        
        var timeOfDay = solarEntity.getAdjustedTimeOfDay();
        var data = getDataFromCache(instanceId);
        if (timeOfDay > 13000) {
            data.method_34965(0f);
        }
        
        var directionPercent = (timeOfDay - 6000) / 6000f;
        var maxAngle = 45;
        var targetAngle = directionPercent * maxAngle * Geometry.DEG_TO_RAD;
        var lastAngle = data.method_15441();
        var angle = LaserArmModel.lerp(lastAngle, targetAngle, 0.06f);
        var bone = data.method_15442();
        bone.setRotZ(angle);
        data.method_34965(angle);
        
    }
}
