package rearth.oritech.block.entity.arcane;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.init.ParticleContent.SoulParticleData;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;

import rearth.oritech.util.ComparatorOutputProvider;

public class SpawnerControllerBlockEntity extends BaseSoulCollectionEntity implements class_5558<SpawnerControllerBlockEntity>, ComparatorOutputProvider {
    
    public int maxSouls = 100_000;
    public int collectedSouls = 0;
    
    public class_1299<?> spawnedMob;
    public class_1297 renderedEntity;
    private boolean networkDirty;
    public boolean hasCage;
    private int lastComparatorOutput;
    private boolean redstonePowered;
    
    // loading cache only
    private class_2960 loadedMob;
    
    // client only
    public float lastProgress = 0f;
    
    public SpawnerControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.SPAWNER_CONTROLLER_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, SpawnerControllerBlockEntity blockEntity) {
        
        if (world.field_9236) return;
        
        if (loadedMob != null && spawnedMob == null) {
            loadEntityFromIdentifier(loadedMob);
            loadedMob = null;
            this.method_5431();
        }
        
        if (spawnedMob == null || !hasCage || redstonePowered) return;
        
        if (collectedSouls >= maxSouls && world.method_8510() % 4 == 0) {
            spawnMob();
            updateComparator();
        }
        
        if (networkDirty) {
            updateNetwork();
            DeathListener.resetEvents();
        }
        
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("souls", collectedSouls);
        nbt.method_10569("maxSouls", maxSouls);
        nbt.method_10556("cage", hasCage);
        nbt.method_10556("redstone", redstonePowered);
        if (spawnedMob != null) {
            nbt.method_10582("spawnedMob", class_7923.field_41177.method_10221(spawnedMob).toString());
        }
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        hasCage = nbt.method_10577("cage");
        maxSouls = nbt.method_10550("maxSouls");
        collectedSouls = nbt.method_10550("souls");
        redstonePowered = nbt.method_10577("redstone");
        
        if (nbt.method_10545("spawnedMob"))
            loadedMob = class_2960.method_60654(nbt.method_10558("spawnedMob"));
    }
    
    private void spawnMob() {
        // try and find a valid position within 10 attempts
        var spawnRange = 4;
        var requiredHeight = Math.round(spawnedMob.method_17686() + 0.5f);
        
        var targetPosition = findSpawnPosition(spawnRange, requiredHeight);
        
        if (targetPosition == null) return;
        networkDirty = true;
        
        spawnedMob.method_47821((class_3218) field_11863, targetPosition, class_3730.field_16469);
        collectedSouls -= maxSouls;
        ParticleContent.SOUL_USED.spawn(field_11863, targetPosition.method_46558(), maxSouls);
        
    }
    
    private class_2338 findSpawnPosition(int spawnRange, int requiredHeight) {
        for (int i = 0; i < 10; i++) {
            var candidate = field_11867.method_10069(field_11863.field_9229.method_39332(-spawnRange, spawnRange), 3, field_11863.field_9229.method_39332(-spawnRange, spawnRange));
            var foundFree = 0;
            for (int j = 0; j < 9; j++) {
                var state = field_11863.method_8320(candidate.method_10087(j));
                if (state.method_26215()) {
                    foundFree++;
                } else {
                    if (foundFree > requiredHeight) {
                        // found target
                        return candidate.method_10087(j - 1);
                        
                    } else {
                        foundFree = 0;
                    }
                }
            }
        }
        
        return null;
    }
    
    private void updateNetwork() {
        networkDirty = false;
        
        if (spawnedMob != null)
            NetworkManager.sendBlockHandle(this, new SpawnerSyncPacket(field_11867, class_7923.field_41177.method_10221(spawnedMob), hasCage, collectedSouls, maxSouls));
    }
    
    public static void receiveUpdatePacket(SpawnerSyncPacket message, class_1937 world, class_5455 dynamicRegistryManager) {
        
        if (world.method_8321(message.position) instanceof SpawnerControllerBlockEntity spawnerEntity) {
            spawnerEntity.loadEntityFromIdentifier(message.spawnedMob);
            spawnerEntity.hasCage = message.hasCage;
            spawnerEntity.collectedSouls = message.collectedSouls;
            spawnerEntity.maxSouls = message.maxSouls;
        }
    }
    
    @Override
    public void method_5431() {
        super.method_5431();
        this.networkDirty = true;
    }
    
    public void loadEntityFromIdentifier(class_2960 identifier) {
        var newMob = class_7923.field_41177.method_10223(identifier);
        
        if (newMob != spawnedMob) {
            spawnedMob = newMob;
            renderedEntity = spawnedMob.method_5883(field_11863);
        }
    }
    
    @Override
    public boolean canAcceptSoul() {
        return collectedSouls < maxSouls;
    }
    
    private void updateComparator() {
        var progress = getComparatorOutput();
        if (lastComparatorOutput != progress) {
            lastComparatorOutput = progress;
            field_11863.method_8455(field_11867, method_11010().method_26204());
        }
        
    }

    @Override
    public int getComparatorOutput() {
        if (spawnedMob == null || maxSouls == 0) return 0;
        
        return  (int) (collectedSouls / (float) maxSouls * 15);
    }
    
    public void setRedstonePowered(boolean active) {
        this.redstonePowered = active;
    }
    
    @Override
    public void onSoulIncoming(class_243 source) {
        var distance = (float) source.method_1022(field_11867.method_46558());
        collectedSouls++;
        
        var soulPath = field_11867.method_46558().method_1020(source);
        var animData = new ParticleContent.SoulParticleData(soulPath, (int) getSoulTravelDuration(distance));
        
        ParticleContent.WANDERING_SOUL.spawn(field_11863, source.method_1031(0, 0.7f, 0), animData);
        networkDirty = true;
        updateComparator();
    }
    
    private int getSoulCost(int maxHp) {
        return (int) (Math.sqrt(maxHp) + 0.5f) * Oritech.CONFIG.spawnerCostMultiplier();
    }
    
    public void onEntitySteppedOn(class_1297 entity) {
        if (spawnedMob != null) return;
        
        if (entity instanceof class_1308 mobEntity) {
            
            if (mobEntity.method_5864().arch$holder().method_40220(TagContent.SPAWNER_BLACKLIST)) {
                Oritech.LOGGER.debug("Ignored blacklisted entity for spawner: " + mobEntity.method_5864().arch$registryName());
                return;
            }
            
            spawnedMob = mobEntity.method_5864();
            
            
            networkDirty = true;
            maxSouls = getSoulCost((int) mobEntity.method_6063());
            
            mobEntity.method_5650(class_1297.class_5529.field_26999);
            reloadCage(null);
            
            this.method_5431();
        }
    }
    
    public void onBlockInteracted(class_1657 player) {
        
        if (spawnedMob == null) {
            player.method_43496(class_2561.method_43471("message.oritech.spawner.no_mob"));
            return;
        }
        
        networkDirty = true;
        
        reloadCage(player);
        
        if (hasCage)
            player.method_43496(class_2561.method_43469("tooltip.oritech.spawner.collected_souls", collectedSouls, maxSouls));
    }
    
    private void reloadCage(@Nullable class_1657 player) {
        var cageSize = new class_2382(Math.round(spawnedMob.method_17685() * 2 + 0.5f), Math.round(spawnedMob.method_17686() + 0.5f), Math.round(spawnedMob.method_17685() * 2 + 0.5f));
        var offset = cageSize.method_10263() / 2;
        
        hasCage = true;
        
        for (int x = 0; x < cageSize.method_10263(); x++) {
            for (int y = 0; y < cageSize.method_10264(); y++) {
                for (int z = 0; z < cageSize.method_10260(); z++) {
                    var candidate = field_11867.method_10069(-offset + x, -y - 1, -offset + z);
                    
                    // block type is a placeholder
                    if (!field_11863.method_8320(candidate).method_26204().equals(BlockContent.SPAWNER_CAGE_BLOCK)) {
                        hasCage = false;
                        ParticleContent.DEBUG_BLOCK.spawn(field_11863, class_243.method_24954(candidate));
                    }
                    
                }
            }
        }
        
        if (!hasCage && player != null) {
            player.method_43496(class_2561.method_43471("message.oritech.spawner.no_cage"));
        }
        
        this.method_5431();
    }
    
    public record SpawnerSyncPacket(class_2338 position, class_2960 spawnedMob, boolean hasCage, int collectedSouls, int maxSouls) implements class_8710 {
        
        public static final class_8710.class_9154<SpawnerSyncPacket> PACKET_ID = new class_8710.class_9154<>(Oritech.id("spawner"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    } {
    }
}
