package rearth.oritech.block.blocks.arcane;

import rearth.oritech.init.BlockContent;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_5712;
import net.minecraft.class_5819;

public class WitheredCropBlock extends class_2302 {
    
    private static final class_265[] AGE_TO_SHAPE = new class_265[]{
      class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 3.0D, 16.0D),
      class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 4.0D, 16.0D),
      class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 5.0D, 16.0D),
      class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 6.0D, 16.0D),
      class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 8.0D, 16.0D),
      class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 10.0D, 16.0D),
      class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 13.0D, 16.0D),
      class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 15.0D, 16.0D)
    };
    
    public WitheredCropBlock(class_2251 settings) {
        super(settings);
    }
    
    @Override
    protected class_1935 method_9832() {
        return BlockContent.WITHER_CROP_BLOCK;
    }
    
    @Override
    protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
        return floor.method_27852(class_2246.field_22090);
    }
    
    @Override
    protected int method_9831(class_1937 world) {
        return class_3532.method_15395(world.field_9229, 1, 2);
    }
    
    @Override
    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (world.method_22335(pos, 0) >= 9) {
            int age = this.method_9829(state);
            if (age < this.method_9827()) {
                if (random.method_43048(5) == 0) {
                    world.method_8652(pos, this.method_9828(age + 1), class_2248.field_31028);
                }
            }
        }
    }
    
    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return AGE_TO_SHAPE[state.method_11654(this.method_9824())];
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (this.method_9829(state) == this.method_9827())
            world.method_55764(class_5712.field_37676.method_40237(), pos, class_5712.class_7397.method_43287(state));
        return super.method_9576(world, pos, state, player);
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        tooltip.add(class_2561.method_43471("tooltip.oritech.soul_crop").method_27692(class_124.field_1080));
    }
}
