package rearth.oritech.util.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.wispforest.owo.registration.reflect.BlockRegistryContainer;
import rearth.oritech.Oritech;

import java.lang.reflect.Field;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public interface ArchitecturyBlockRegistryContainer extends ArchitecturyRegistryContainer<class_2248> {
    
    DeferredRegister<class_1792> ITEM_REGISTRY = DeferredRegister.create(Oritech.MOD_ID, class_7924.field_41197);
    
    @Override
    default class_5321<class_2378<class_2248>> getRegistryType() {
        return class_7924.field_41254;
    }
    
    @Override
    default Class<class_2248> getTargetFieldType() {
        return class_2248.class;
    }
    
    @Override
    default void postProcessField(String namespace, class_2248 value, String identifier, Field field, RegistrySupplier<class_2248> supplier) {
        if (field.isAnnotationPresent(BlockRegistryContainer.NoBlockItem.class)) return;
        ITEM_REGISTRY.register(identifier, () -> createBlockItem(value, identifier));
    }
    
    default class_1747 createBlockItem(class_2248 block, String identifier) {
        return new class_1747(block, new class_1792.class_1793());
    }
    
    static void finishItemRegister() {
        ITEM_REGISTRY.register();
    }
    
}
