package rearth.oritech.client.ui;

import io.wispforest.owo.client.screens.SlotGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.ScreenProvider.GuiSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class BasicMachineScreenHandler extends class_1703 {
    
    @NotNull
    protected final class_1661 playerInventory;
    @NotNull
    protected final class_1263 inventory;
    @NotNull
    protected final EnergyApi.EnergyStorage energyStorage;
    
    @NotNull
    protected final class_2338 blockPos;
    
    @NotNull
    public final ScreenProvider screenData;
    
    @Nullable
    protected final FluidApi.SingleSlotStorage steamStorage;
    @Nullable
    protected final FluidApi.SingleSlotStorage waterStorage;
    @Nullable
    protected FluidApi.SingleSlotStorage mainFluidContainer;
    
    protected class_2680 machineBlock;
    public class_2586 blockEntity;
    protected List<Integer> armorSlots;
    
    public BasicMachineScreenHandler(int syncId, class_1661 inventory, class_2540 buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.field_7546.method_37908().method_8321(buf.method_10811())));
    }
    
    // on server, also called from client constructor
    public BasicMachineScreenHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity) {
        super(((ScreenProvider) blockEntity).getScreenHandlerType(), syncId);
        
        this.screenData = (ScreenProvider) blockEntity;
        this.blockPos = blockEntity.method_11016();
        this.inventory = screenData.getDisplayedInventory();
        if (inventory != null)
            inventory.method_5435(playerInventory.field_7546);
        this.playerInventory = playerInventory;
        
        if (blockEntity instanceof EnergyApi.BlockProvider energyProvider) {
            energyStorage = energyProvider.getEnergyStorage(null);
        } else {
            energyStorage = null;
        }
        
        if (blockEntity instanceof FluidApi.BlockProvider blockProvider && blockProvider.getFluidStorage(null) instanceof SimpleFluidStorage container) {
            this.mainFluidContainer = container;
        } else {
            mainFluidContainer = null;
        }
        
        this.machineBlock = blockEntity.method_11010();
        this.blockEntity = blockEntity;
        
        if (this.blockEntity instanceof UpgradableGeneratorBlockEntity generatorEntity && generatorEntity.isProducingSteam) {
            waterStorage = generatorEntity.boilerStorage.getInputContainer();
            steamStorage = generatorEntity.boilerStorage.getOutputContainer();
        } else if (this.blockEntity instanceof SteamEngineEntity steamEngineEntity) {
            waterStorage = steamEngineEntity.boilerStorage.getOutputContainer();
            steamStorage = steamEngineEntity.boilerStorage.getInputContainer();
        } else {
            steamStorage = null;
            waterStorage = null;
        }
        
        buildItemSlots();
    }
    
    private void buildItemSlots() {
        
        for (var slot : screenData.getGuiSlots()) {
            addMachineSlot(slot.index(), slot.x(), slot.y(), slot.output());
        }
        
        SlotGenerator.begin(this::method_7621, 8, 84)
          .playerInventory(playerInventory);
        
        if (screenData.showArmor()) {
            armorSlots = new ArrayList<>(5);
            for (int i = 0; i < playerInventory.field_7548.size() + 1; i++) {
                final var iteration = i;
                var index = this.method_7621(new class_1735(playerInventory, 36 + i, -20, i * 19) {
                    @Override
                    public boolean method_7680(class_1799 stack) {
                        if (iteration == 4) return super.method_7680(stack);  // offhand, to prevent dupes
                        
                        if (stack.method_7909() instanceof class_1738 armorItem) {
                            return super.method_7680(stack) && armorItem.method_7685().method_5927() == iteration;
                        }
                        return false;
                    }
                });
                armorSlots.add(index.field_7874);
            }
        }
    }
    
    public void addMachineSlot(int inventorySlot, int x, int y, boolean output) {
        if (output) {
            this.method_7621(new BasicMachineOutputSlot(inventory, inventorySlot, x, y));
        } else {
            this.method_7621(new class_1735(inventory, inventorySlot, x, y));
        }
    }
    
    @Override
    public class_1799 method_7601(class_1657 player, int invSlot) {
        
        var newStack = class_1799.field_8037;
        
        var slot = this.field_7761.get(invSlot);
        
        if (slot.method_7681()) {
            var originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < this.inventory.method_5439() || invSlot >= this.inventory.method_5439() + 36) {  // second condition is for machines adding extra slots afterwards, which are treated as part of the machine
                if (!this.method_7616(originalStack, getPlayerInvStartSlot(newStack), getPlayerInvEndSlot(newStack), true)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(originalStack, getMachineInvStartSlot(newStack), getMachineInvEndSlot(newStack), false)) {
                return class_1799.field_8037;
            }
            
            if (originalStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        
        return newStack;
    }
    
    // order is:
    // machine inv slots
    // player inv slots
    // player equipment slots
    
    public int getPlayerInvStartSlot(class_1799 stack) {
        return this.inventory.method_5439();
    }
    
    public int getPlayerInvEndSlot(class_1799 stack) {
        
        if (screenData.showArmor()) {
            return this.field_7761.size() - 1;   // don't include offhand slot
        }
        return this.field_7761.size();
    }
    
    public int getMachineInvStartSlot(class_1799 stack) {
        return 0;
    }
    
    public int getMachineInvEndSlot(class_1799 stack) {
        return this.inventory.method_5439();
    }
    
    @Override
    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }
    
    public @NotNull class_2338 getBlockPos() {
        return blockPos;
    }
    
    public boolean showRedstoneAddon() {
        return screenData.hasRedstoneControlAvailable();
    }
    
    @Override
    public void method_7623() {
        
        if (blockEntity instanceof NetworkedBlockEntity networkedBlockEntity)
            networkedBlockEntity.sendUpdate(SyncType.GUI_TICK, (class_3222) this.player());
        
        super.method_7623();
    }
}
