package rearth.oritech.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;

import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5819;
import net.minecraft.class_7833;

import static net.minecraft.class_4668.field_22241;
import static net.minecraft.class_2350.*;
import static net.minecraft.class_2350.field_11033;


public class LaserArmRenderer<T extends LaserArmBlockEntity & GeoAnimatable> extends GeoBlockRenderer<T> {
    
    public LaserArmRenderer(String modelPath) {
        super(new LaserArmModel<>(modelPath));
        addRenderLayer(new AutoGlowingGeoLayer<>(this));
    }
    
    // Modified RenderLayer.LINES
    public static final class_1921.class_4687 CUSTOM_LINES = class_1921.method_24048("lines", class_290.field_29337, class_293.class_5596.field_27377, 1536, class_1921.class_4688.method_23598().method_34578(class_4668.field_29433).method_23607(field_22241).method_23615(class_4668.field_21370).method_23610(class_4668.field_25643).method_23616(class_4668.field_21349).method_23603(class_4668.field_21345).method_23617(false));
    private static final HashMap<Long, class_243> cachedOffsets = new HashMap<>();
    
    
    @Override
    public int method_33893() {
        return 128;
    }
    
    @Override
    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }
    
    @Override
    public void postRender(class_4587 matrices, T laserEntity, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(matrices, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        
        if (laserEntity.getCurrentTarget() == null || !laserEntity.isFiring()) return;
        
        var facing = laserEntity.method_11010().method_11654(class_2741.field_12525);
        var startPos = laserEntity.laserHead;
        var startOffset = new class_243(0, 1.65f, 0);
        
        var targetPos = laserEntity.getVisualTarget();
        var targetBlock = laserEntity.method_10997().method_8320(laserEntity.getCurrentTarget()).method_26204();
        if (laserEntity.isTargetingAtomicForge(targetBlock)) { // adjust so the beam end faces one of the corner pillars
            var moveX = 0.5;
            var moveZ = 0.5;
            if (startPos.field_1352 < targetPos.field_1352) moveX = -0.5;
            if (startPos.field_1350 < targetPos.field_1350) moveZ = -0.5;
            targetPos = targetPos.method_1031(moveX, 0.5, moveZ);
        } else if (laserEntity.isTargetingDeepdrill(targetBlock)) {
            var offset = cachedOffsets.computeIfAbsent(laserEntity.method_11016().method_10063(), id -> idToOffset(class_2338.method_10092(id), 0.5f, laserEntity.method_10997(), laserEntity.getCurrentTarget()));
            targetPos = targetPos.method_1019(offset);
        }
        
        if (laserEntity.lastRenderPosition == null) laserEntity.lastRenderPosition = targetPos;
        targetPos = lerp(laserEntity.lastRenderPosition, targetPos, 0.06f);
        laserEntity.lastRenderPosition = targetPos;
        
        var targetPosOffset = worldToOffsetPosition(facing, targetPos, startPos).method_1019(startOffset);
        
        var forward = targetPos.method_1020(startPos).method_1029();
        if (!laserEntity.isTargetingEnergyContainer() && !laserEntity.isTargetingBuddingAmethyst() && laserEntity.method_10997().field_9229.method_43057() > 0.7)
            ParticleContent.LASER_BEAM_EFFECT.spawn(laserEntity.method_10997(), targetPos.method_1031(0.5, 0, 0.5).method_1020(forward.method_1021(0.6)));
        
        var cross = forward.method_1036(new class_243(0, 1, 0));
        
        matrices.method_22903();
        var lineConsumer = bufferSource.getBuffer(CUSTOM_LINES);
        
        // to prevent line from becoming too big when further away, as the size seems to be in screen space
        var camPos = class_310.method_1551().field_1719.method_19538();
        var camDist = camPos.method_1020(startPos).method_1033();
        var widthMultiplier = 1f;
        if (camDist > 20)
            widthMultiplier = (float) (camDist / 20f);
        RenderSystem.lineWidth((float) (Math.sin((laserEntity.method_10997().method_8510() + partialTick) * 0.3) * 2 + 7) / widthMultiplier);
        
        // startOffset = new Vec3d(0, 2, 0);
        // targetPosOffset = new Vec3d(0, 5, 0);
        
        lineConsumer.method_22918(matrices.method_23760().method_23761(), (float) startOffset.field_1352, (float) startOffset.field_1351, (float) startOffset.field_1350)
          .method_1336(138, 242, 223, 255)
          .method_60803(packedLight)
          .method_22922(packedOverlay)
          .method_22914(0, 1, 0);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), (float) targetPosOffset.field_1352, (float) targetPosOffset.field_1351, (float) targetPosOffset.field_1350)
          .method_1336(19, 91, 80, 255)
          .method_60803(packedLight)
          .method_22922(packedOverlay)
          .method_22914(1, 0, 0);
        
        // render a second one at right angle to first one
        lineConsumer.method_22918(matrices.method_23760().method_23761(), (float) startOffset.field_1352, (float) startOffset.field_1351, (float) startOffset.field_1350)
          .method_1336(138, 242, 223, 255)
          .method_60803(packedLight)
          .method_22922(packedOverlay)
          .method_22914((float) cross.field_1352, (float) cross.field_1351, (float) cross.field_1350);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), (float) targetPosOffset.field_1352, (float) targetPosOffset.field_1351, (float) targetPosOffset.field_1350)
          .method_1336(19, 91, 80, 255)
          .method_60803(packedLight)
          .method_22922(packedOverlay)
          .method_22914((float) cross.field_1352, (float) cross.field_1351, (float) cross.field_1350);
        
        matrices.method_22909();
    }
    
    public static class_243 idToOffset(class_2338 source, float range, class_1937 world, class_2338 targetPos) {
        
        var drillFacing = world.method_8320(targetPos).method_11654(class_2741.field_12481);
        var drillCenter = Geometry.rotatePosition(new class_243(1, 1.4, 0), drillFacing);
        
        var random = class_5819.method_43049(source.method_10063());
        return new class_243((random.method_43057() * 2 - 1) * range, (random.method_43057() * 2 - 1) * range, (random.method_43057() * 2 - 1) * range).method_1019(drillCenter);
    }
    
    @Override
    protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        if (Objects.requireNonNull(facing) == class_2350.field_11033) {
            poseStack.method_46416(0,  1, 0);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180));
        } else if (facing == class_2350.field_11039) {
            poseStack.method_22904(0.5,  0.5, 0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(90));
        } else if (facing == class_2350.field_11034) {
            poseStack.method_22904(-0.5,  0.5, 0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(270));
        } else if (facing == class_2350.field_11035) {
            poseStack.method_22904(0,  0.5, -0.5);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(90));
        } else if (facing == class_2350.field_11043) {
            poseStack.method_22904(0,  0.5, 0.5);
            poseStack.method_22907(class_7833.field_40713.rotationDegrees(90));
        }
    }
    
    public static class_243 lerp(class_243 a, class_243 b, float f) {
        return new class_243(lerp(a.field_1352, b.field_1352, f), lerp(a.field_1351, b.field_1351, f), lerp(a.field_1350, b.field_1350, f));
    }
    
    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }
    
    private static class_243 worldToOffsetPosition(class_2350 facing, class_243 worldTarget, class_243 ownPos) {
        class_243 relativeWorld = worldTarget.method_1020(ownPos);
        
        double relX = relativeWorld.method_10216();
        double relY = relativeWorld.method_10214();
        double relZ = relativeWorld.method_10215();
        
        if (Objects.requireNonNull(facing) == field_11043) {
            return new class_243(relX, -relZ, relY);
        } else if (facing == field_11035) {
            return new class_243(relX, relZ, -relY);
        } else if (facing == field_11039) {
            return new class_243(relY, -relX, relZ);
        } else if (facing == field_11034) {
            return new class_243(-relY, relX, relZ);
        } else if (facing == field_11036) {
            return new class_243(relX, relY, relZ);
        } else if (facing == field_11033) {
            return new class_243(relX, -relY, -relZ);
        }
        throw new IllegalArgumentException();
        
    }
}


