package rearth.oritech.block.entity.interaction;

import com.mojang.authlib.GameProfile;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockFrameInteractionEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.FakeMachinePlayer;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9300;
import net.minecraft.class_9334;

public class DestroyerBlockEntity extends MultiblockFrameInteractionEntity {

    @SyncField(SyncType.GUI_OPEN)
    public boolean hasCropFilterAddon;
    @SyncField(SyncType.GUI_OPEN)
    public boolean hasSilkTouchAddon;
    @SyncField(SyncType.GUI_OPEN)
    public int yieldAddons = 0;
    @SyncField({SyncType.GUI_OPEN, SyncType.SPARSE_TICK})
    public int range = 1;

    // non-persistent
    @SyncField
    public class_2338 quarryTarget = class_2338.field_10980;
    
    public float targetHardness = 1f;
    private class_3222 destroyerPlayerEntity = null;

    public DestroyerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.DESTROYER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void gatherAddonStats(List<AddonBlock> addons) {
        range = 1;
        yieldAddons = 0;
        hasSilkTouchAddon = false;
        super.gatherAddonStats(addons);
    }

    @Override
    public void getAdditionalStatFromAddon(AddonBlock addonBlock) {
        if (addonBlock.state().method_26204().equals(BlockContent.CROP_FILTER_ADDON))
            hasCropFilterAddon = true;

        if (addonBlock.state().method_26204().equals(BlockContent.QUARRY_ADDON))
            range *= 8;

        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_YIELD_ADDON))
            yieldAddons++;

        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_SILK_TOUCH_ADDON))
            hasSilkTouchAddon = true;


        super.getAdditionalStatFromAddon(addonBlock);
        
        yieldAddons = Math.min(yieldAddons, 3);
    }

    @Override
    public void resetAddons() {
        super.resetAddons();
        hasCropFilterAddon = false;
        hasSilkTouchAddon = false;
        range = 1;
        yieldAddons = 0;
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("cropAddon", hasCropFilterAddon);
        nbt.method_10556("silkTouchAddon", hasSilkTouchAddon);
        nbt.method_10569("range", range);
        nbt.method_10569("yield", yieldAddons);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        hasCropFilterAddon = nbt.method_10577("cropAddon");
        hasSilkTouchAddon = nbt.method_10577("silkTouchAddon");
        range = nbt.method_10550("range");
        yieldAddons = nbt.method_10550("yield");
    }

    @Override
    protected boolean hasWorkAvailable(class_2338 toolPosition) {

        if (range > 1) {
            return hasQuarryTarget(toolPosition);
        }

        var targetPosition = toolPosition.method_10074();
        var targetState = Objects.requireNonNull(field_11863).method_8320(targetPosition);

        // skip not grown crops
        if (hasCropFilterAddon && isImmatureCrop(targetState)) {
            return false;
        }

        return !targetState.method_26204().equals(class_2246.field_10124);
    }

    private class_1657 getDestroyerPlayerEntity() {
        if (destroyerPlayerEntity == null && field_11863 instanceof class_3218 serverWorld) {
            destroyerPlayerEntity = FakeMachinePlayer.create(serverWorld, new GameProfile(UUID.randomUUID(), "oritech_destroyer"), inventory);
        }

        return destroyerPlayerEntity;
    }

    private boolean hasQuarryTarget(class_2338 toolPosition) {
        return getQuarryDownwardState(toolPosition) != null;
    }

    public static boolean isImmatureCrop(class_2680 targetState) {
        class_2248 targetBlock = targetState.method_26204();
        return (targetBlock instanceof class_2302 cropBlock && !cropBlock.method_9825(targetState))
                || (targetBlock instanceof class_2421 && targetState.method_11654(class_2421.field_11306) < class_2421.field_31199)
                || (targetBlock instanceof class_2282 && targetState.method_11654(class_2282.field_10779) < class_2282.field_31061);
    }

    private class_3545<class_2338, class_2680> getQuarryDownwardState(class_2338 toolPosition) {
        for (int i = 1; i <= range; i++) {
            var checkPos = toolPosition.method_10087(i);
            var targetState = field_11863.method_8320(checkPos);
            if (!targetState.method_26215() && targetState.method_26227().method_15769()) {  // pass through both air and liquid
                quarryTarget = checkPos;
                targetHardness = Math.clamp(targetState.method_26214(field_11863, checkPos), 0, 100);
                return new class_3545<>(checkPos, targetState);
            }
        }

        quarryTarget = class_2338.field_10980;
        return null;
    }

    @Override
    public void finishBlockWork(class_2338 processed) {

        var targetPosition = processed.method_10074();
        var targetState = Objects.requireNonNull(field_11863).method_8320(targetPosition);

        if (range > 1) {
            if (quarryTarget != class_2338.field_10980) {
                targetPosition = quarryTarget;
                targetState = field_11863.method_8320(targetPosition);
            } else {
                var data = getQuarryDownwardState(processed);
                if (data == null) return;
                targetPosition = data.method_15442();
                targetState = data.method_15441();
            }
        }

        // remove fluids
        if (!targetState.method_26227().method_15769()) {
            field_11863.method_8501(targetPosition, class_2246.field_10124.method_9564());
        }

        var targetHardness = targetState.method_26204().method_36555();
        if (targetHardness < 0) return;    // skip undestroyable blocks, such as bedrock

        // skip not grown crops
        if (range == 1 && hasCropFilterAddon && isImmatureCrop(targetState)) {
            return;
        }

        if (!targetState.method_26204().equals(class_2246.field_10124)) {

            var targetEntity = field_11863.method_8321(targetPosition);
            List<class_1799> dropped;
            if (hasSilkTouchAddon) {
                dropped = getSilkTouchDrops(targetState, (class_3218) field_11863, targetPosition, targetEntity, getDestroyerPlayerEntity());
            } else if (yieldAddons > 0) {
                dropped = getLootDrops(targetState, (class_3218) field_11863, targetPosition, targetEntity, yieldAddons, getDestroyerPlayerEntity());
            } else {
                dropped = class_2248.method_9562(targetState, (class_3218) field_11863, targetPosition, targetEntity);
            }

            if (dropped.isEmpty()) {
                // If the block doesn't drop any loot, try to break it again with shears
                // Good for seagrass, cobwebs, vines, etc.
                dropped = class_2248.method_9609(targetState, (class_3218) field_11863, targetPosition, targetEntity, null, new class_1799(class_1802.field_8868));
            }

            // only proceed if all stacks fit
            for (var stack : dropped) {
                if (this.inventory.insert(stack, true) != stack.method_7947()) return;
            }

            for (var stack : dropped) {
                this.inventory.insert(stack, false);
            }

            targetState.method_26204().method_9576(field_11863, targetPosition, targetState, getDestroyerPlayerEntity());
            field_11863.method_8396(null, targetPosition, targetState.method_26231().method_10595(), class_3419.field_15245, 1f, 1f);
            field_11863.method_22352(targetPosition, false);
            super.finishBlockWork(processed);
        }
    }

    public static List<class_1799> getLootDrops(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, int yieldAddons, @Nullable class_1657 entity) {

        var sampleTool = new class_1799(class_1802.field_22024);
        sampleTool.method_57379(class_9334.field_49630, new class_9300(false));
        var fortuneEntry = world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9130).get();
        sampleTool.method_7978(fortuneEntry, Math.min(yieldAddons, 3));

        var builder = new class_8567.class_8568(world).method_51874(class_181.field_24424, class_243.method_24953(pos))
                .method_51874(class_181.field_1229, sampleTool)
                .method_51877(class_181.field_1228, blockEntity);
        if (entity != null)
            builder.method_51877(class_181.field_1226, entity);
        return state.method_26189(builder);
    }

    public static List<class_1799> getSilkTouchDrops(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, @Nullable class_1657 entity) {
        var sampleTool = new class_1799(class_1802.field_22024);
        sampleTool.method_57379(class_9334.field_49630, new class_9300(false));
        var silkTouchEntry = world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9099).get();
        sampleTool.method_7978(silkTouchEntry, 1);

        var builder = new class_8567.class_8568(world).method_51874(class_181.field_24424, class_243.method_24953(pos))
                .method_51874(class_181.field_1229, sampleTool)
                .method_51877(class_181.field_1228, blockEntity);
        if (entity != null)
            builder.method_51877(class_181.field_1226, entity);
        return state.method_26189(builder);
    }

    @Override
    protected void doProgress(boolean moving) {
        super.doProgress(moving);

        if (moving)
            return;

        if (range > 1 && quarryTarget != class_2338.field_10980) {
            ParticleContent.QUARRY_DESTROY_EFFECT.spawn(field_11863, class_243.method_24953(quarryTarget).method_1031(0, 0.5, 0), 3);
        } else if (hasWorkAvailable(getCurrentTarget())) {
            ParticleContent.BLOCK_DESTROY_EFFECT.spawn(field_11863, class_243.method_24954(getCurrentTarget().method_10074()), 4);
        }
    }

    @Override
    public List<class_3545<class_2561, class_2561>> getExtraExtensionLabels() {
        if (range == 1 && yieldAddons == 0 && !hasSilkTouchAddon) return super.getExtraExtensionLabels();
        if (hasSilkTouchAddon) {
            return List.of(new class_3545<>(
              class_2561.method_43469("title.oritech.machine.addon_range", range),
              class_2561.method_43471("tooltip.oritech.block_destroyer.addon_range")),
              new class_3545<>(class_2561.method_43471("enchantment.minecraft.silk_touch"),
                class_2561.method_43471("tooltip.oritech.machine.addon_silk_touch")));
        }
        return List.of(new class_3545<>(class_2561.method_43469("title.oritech.machine.addon_range", range), class_2561.method_43471("tooltip.oritech.block_destroyer.addon_range")), new class_3545<>(class_2561.method_43469("title.oritech.machine.addon_fortune", yieldAddons), class_2561.method_43471("tooltip.oritech.machine.addon_fortune")));
    }

    @Override
    public class_2680 getMachineHead() {
        return BlockContent.BLOCK_DESTROYER_HEAD.method_9564();
    }

    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
                new GuiSlot(0, 117, 20, true),
                new GuiSlot(1, 117, 38, true),
                new GuiSlot(2, 135, 20, true),
                new GuiSlot(3, 135, 38, true));
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(
                new class_2382(0, 0, -2),
                new class_2382(-1, 0, -1),
                new class_2382(0, 0, 2),
                new class_2382(-1, 0, 1)
        );
    }

    @Override
    public float getMoveTime() {
        var quarrySpeedBonus = range > 1 ? 0.15f : 1f;
        return Oritech.CONFIG.destroyerConfig.moveDuration() * this.getSpeedMultiplier() * quarrySpeedBonus;
    }

    @Override
    public float getWorkTime() {
        var quarrySpeedBonus = range > 1 ? 0.15f : 1f;
        return (float) (Oritech.CONFIG.destroyerConfig.workDuration() * this.getSpeedMultiplier() * Math.pow(targetHardness, 0.5f) * quarrySpeedBonus);
    }

    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.destroyerConfig.moveEnergyUsage();
    }

    @Override
    public int getOperationEnergyUsage() {
        var quarryCostBonus = range > 1 ? 4 : 1;
        return Oritech.CONFIG.destroyerConfig.workEnergyUsage() * quarryCostBonus;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.DESTROYER_SCREEN;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
                new class_2382(0, 0, -1),
                new class_2382(0, 0, 1)
        );
    }
}
