package rearth.oritech.block.blocks.decorative;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.init.BlockContent;

public class MetalGirderBlock extends class_2383 {
    
    public static final class_2746 HEADING = class_2746.method_11825("heading");
    
    private static final class_265 NORTH_SHAPE = class_2248.method_9541(0, 4, 4, 16, 12, 12);
    private static final class_265 EAST_SHAPE = class_2248.method_9541(4, 4, 0, 12, 12, 16);
    
    public MetalGirderBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(HEADING, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(HEADING);
        builder.method_11667(class_2741.field_12481);
    }
    
    @Override
    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        var facing = state.method_11654(class_2741.field_12481);
        if (facing.method_10166().equals(class_2350.class_2351.field_11048)) return NORTH_SHAPE;
        return EAST_SHAPE;
    }
    
    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return method_9549(state, world, pos, context);
    }
    
    @Override
    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        
        var facing = state.method_11654(class_2741.field_12481);
        var blockInBack = world.method_8320(pos.method_10081(facing.method_10163())).method_27852(BlockContent.METAL_GIRDER_BLOCK);
        var blockInFront = world.method_8320(pos.method_10081(facing.method_10153().method_10163())).method_27852(BlockContent.METAL_GIRDER_BLOCK);
        var straight = false;
        if (blockInFront && !blockInBack) {
            facing = facing.method_10153();
        } else if (blockInFront && blockInBack) {
            straight = true;
        }
        
        return state.method_11657(class_2741.field_12481, facing).method_11657(HEADING, !straight);
        
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        var world = ctx.method_8045();
        var pos = ctx.method_8037();
        
        // if placed on ceiling/wall, rotate with player facing. Otherwise get surface facing.
        // if block behind is other girder, use straight model. Otherwise it's an endstop.
        
        var facing = ctx.method_8038();
        
        if (ctx.method_8038().method_10166().equals(class_2350.class_2351.field_11052)) {
            facing = ctx.method_8042().method_10153();
        }
        
        var blockInBack = world.method_8320(pos.method_10081(facing.method_10163())).method_27852(BlockContent.METAL_GIRDER_BLOCK);
        var blockInFront = world.method_8320(pos.method_10081(facing.method_10153().method_10163())).method_27852(BlockContent.METAL_GIRDER_BLOCK);
        var straight = false;
        if (blockInFront && !blockInBack) {
            facing = facing.method_10153();
        } else if (blockInFront && blockInBack) {
            straight = true;
        }
        
        return method_9564().method_11657(class_2741.field_12481, facing).method_11657(HEADING, !straight);
    }
    
    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }
}
