package rearth.oritech.block.blocks.arcane;

import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.arcane.SpawnerControllerBlockEntity;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

public class SpawnerControllerBlock extends class_2383 implements class_2343 {
    
    public SpawnerControllerBlock(class_2251 settings) {
        super(settings);
    }
    
    @Override
    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        super.method_9591(world, pos, state, entity);
        
        if (!world.field_9236 && world.method_8321(pos) instanceof SpawnerControllerBlockEntity spawnerEntity) {
            spawnerEntity.onEntitySteppedOn(entity);
        }
        
    }
    
    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }
    
    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        
        if (world.field_9236) return;
        
        var isPowered = world.method_49803(pos);
        
        var entity = (SpawnerControllerBlockEntity) world.method_8321(pos);
        entity.setRedstonePowered(isPowered);
        
    }
    
    @Override
    protected boolean method_9498(class_2680 state) {
        return true;
    }
    
    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return ((SpawnerControllerBlockEntity) world.method_8321(pos)).getComparatorOutput();
    }
    
    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {

        if (!world.field_9236 && world.method_8321(pos) instanceof SpawnerControllerBlockEntity spawnerEntity) {
            spawnerEntity.onBlockInteracted(player);
        }

        return class_1269.field_5812;
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpawnerControllerBlockEntity(pos, state);
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        tooltip.add(class_2561.method_43471("tooltip.oritech.spawner").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43471("tooltip.oritech.spawner2").method_27692(class_124.field_1080));
    }
}
