package rearth.oritech.mixin;

import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rearth.oritech.Oritech;

@Mixin(class_3222.class)
public class ServerPlayerMixin {
    
    @Inject(
      method = "restoreFrom",
      at = @At(
        value = "INVOKE",
        target = "Lnet/minecraft/server/level/ServerPlayer;setHealth(F)V"
      )
    )
    private void onCopyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        var newPlayer = (class_3222) (Object) this; // "this" is the new player instance
        
        // Iterate through all attributes of the old player and copy persistent modifiers.
        oldPlayer.method_6127().method_26851().forEach(oldAttributeInstance -> {
            oldAttributeInstance.method_6195().forEach(oldModifier -> {
                var isAugment = oldModifier.comp_2447().method_12836().equals(Oritech.MOD_ID);
                if (!isAugment) return;
                System.out.println(oldModifier.comp_2447());
                
                var newInstance = newPlayer.method_5996(oldAttributeInstance.method_6198());
                if (newInstance == null) return;
                newInstance.method_61163(oldModifier);
                
            });
        });
    }
}