package rearth.oritech.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_979;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import rearth.oritech.item.tools.armor.JetpackElytraItem;
import rearth.oritech.item.tools.armor.JetpackExoElytraItem;

@Mixin(class_979.class)
public class ElytraLayerMixin {
    
    // I have no idea how to actually configure the mixins, this is taken pretty much straight from mythic metals (https://github.com/Noaaan/MythicMetals/blob/1.21/src/main/java/nourl/mythicmetals/mixin/ElytraFeatureRendererMixin.java)
    @ModifyExpressionValue(
      method = "render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V",
      at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z")
    )
    private boolean oritech$canRenderJetpackElytra(boolean original, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_1309 entity) {
        var item = entity.method_6118(class_1304.field_6174).method_7909();
        return original || item instanceof JetpackElytraItem || item instanceof JetpackExoElytraItem;
    }
    
}
