package rearth.oritech.init.recipes;

import com.mojang.datafixers.util.Either;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.block.entity.augmenter.api.CustomAugmentsCollection;
import rearth.oritech.block.entity.augmenter.api.EffectAugment;
import rearth.oritech.block.entity.augmenter.api.ModifierAugment;
import rearth.oritech.util.SizedIngredient;

import java.util.List;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9695;

public class AugmentDataRecipe implements class_1860<class_9695> {
    
    private final boolean toggleable;
    private final AugmentDataRecipeType type;
    
    private final List<SizedIngredient> researchCost;
    private final List<SizedIngredient> applyCost;
    private final List<class_2960> requirements;
    private final class_2960 requiredStation;
    private final int uiX;
    private final int uiY;
    private final int time;
    private final long rfCost;
    
    // 2 of these 3 should always be null
    private final @Nullable EffectDefinition effectDefinition;
    private final @Nullable ModifierDefinition modifierDefinition;
    private final @Nullable CustomAugmentDefinition customAugmentDefinition;
    
    // this shitty either variant is needed because neoforge datagen wont work with the normal null values
    public AugmentDataRecipe(
      AugmentDataRecipeType type,
      boolean toggleable,
      List<SizedIngredient> researchCost,
      List<SizedIngredient> applyCost,
      List<class_2960> requirements,
      class_2960 requiredStation,
      int uiX,
      int uiY,
      int time,
      long rfCost,
      Either<Either<EffectDefinition, ModifierDefinition>, CustomAugmentDefinition> effect) {
        
        this(type,
          toggleable,
          researchCost,
          applyCost,
          requirements,
          requiredStation,
          uiX,
          uiY,
          time,
          rfCost,
          effect.left().isPresent() ? effect.left().get().left().isPresent() ? effect.left().get().left().get() : null : null,
          effect.left().isPresent() ? effect.left().get().right().isPresent() ? effect.left().get().right().get() : null : null,
          effect.right().isPresent() ? effect.right().get() : null);
    }
    
    public AugmentDataRecipe(
      AugmentDataRecipeType type,
      boolean toggleable,
      List<SizedIngredient> researchCost,
      List<SizedIngredient> applyCost,
      List<class_2960> requirements,
      class_2960 requiredStation,
      int uiX,
      int uiY,
      int time,
      long rfCost,
      @Nullable EffectDefinition effectDefinition,
      @Nullable ModifierDefinition modifierDefinition,
      @Nullable CustomAugmentDefinition customAugmentDefinition) {
        
        this.toggleable = toggleable;
        this.researchCost = researchCost;
        this.applyCost = applyCost;
        this.requirements = requirements;
        this.requiredStation = requiredStation;
        this.uiX = uiX;
        this.uiY = uiY;
        this.time = time;
        this.rfCost = rfCost;
        this.effectDefinition = effectDefinition;
        this.modifierDefinition = modifierDefinition;
        this.customAugmentDefinition = customAugmentDefinition;
        this.type = type;
    }
    
    @Override
    public boolean method_8115(class_9695 input, class_1937 world) {
        throw new UnsupportedOperationException();
    }
    
    @Override
    public class_1799 method_8116(class_9695 input, class_7225.class_7874 lookup) {
        return class_1799.field_8037;
    }
    
    @Override
    public boolean method_8113(int width, int height) {
        return false;
    }
    
    @Override
    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return class_1799.field_8037;
    }
    
    @Override
    public class_1865<?> method_8119() {
        return type;
    }
    
    @Override
    public class_3956<?> method_17716() {
        return type;
    }
    
    public AugmentDataRecipeType getOriType() {
        return type;
    }
    
    public boolean isToggleable() {
        return toggleable;
    }
    
    public Augment createAugment(class_2960 recipeId) {
        if (customAugmentDefinition != null) {
            var customId = customAugmentDefinition.customAugmentId;
            return CustomAugmentsCollection.getById(customId);
        } else if (effectDefinition != null) {
            return new EffectAugment(
              recipeId,
              this.toggleable,
              class_7923.field_41174.method_55841(effectDefinition.potionEffectId).orElseThrow(),
              effectDefinition.effectStrength);
        } else if (modifierDefinition != null) {
            return new ModifierAugment(
              recipeId,
              class_7923.field_41190.method_55841(modifierDefinition.entityAttributeId).orElseThrow(),
              class_1322.class_1323.field_48325.apply(modifierDefinition.attributeOperationType()),
              modifierDefinition.amount(),
              this.toggleable);
        } else {
            throw new IllegalStateException("No augment definition for " + recipeId);
        }
    }
    
    public List<SizedIngredient> getResearchCost() {
        return researchCost;
    }
    
    public List<SizedIngredient> getApplyCost() {
        return applyCost;
    }
    
    public long getRfCost() {
        return rfCost;
    }
    
    public int getTime() {
        return time;
    }
    
    public class_2960 getRequiredStation() {
        return requiredStation;
    }
    
    public List<class_2960> getRequirements() {
        return requirements;
    }
    
    public int getUiX() {
        return uiX;
    }
    
    public int getUiY() {
        return uiY;
    }
    
    public @Nullable EffectDefinition getEffectDefinition() {
        return effectDefinition;
    }
    
    public @Nullable CustomAugmentDefinition getCustomAugmentDefinition() {
        return customAugmentDefinition;
    }
    
    public @Nullable ModifierDefinition getModifierDefinition() {
        return modifierDefinition;
    }
    
    public Either<Either<EffectDefinition, ModifierDefinition>, CustomAugmentDefinition> getDefinition() {
        if (effectDefinition != null) {
            return Either.left(Either.left(effectDefinition));
        } else if (modifierDefinition != null) {
            return Either.left(Either.right(modifierDefinition));
        } else if (customAugmentDefinition != null) {
            return Either.right(customAugmentDefinition);
        }
        
        throw new IllegalStateException("Either effect, modifier or custom augment needs to be set!");
    }
    
    // used to apply an effect, similar to potion effects
    public record EffectDefinition(class_2960 potionEffectId, int effectStrength) {
        public static Endec<EffectDefinition> ENDEC = ReflectiveEndecBuilder.SHARED_INSTANCE.get(EffectDefinition.class);
    }
    
    // apply a stat modification. The attributeOperationType type can be either "add_value=0", "add_multiplied_base=1" or "add_multiplied_total=2"
    public record ModifierDefinition(class_2960 entityAttributeId, int attributeOperationType, float amount) {
        public static Endec<ModifierDefinition> ENDEC = ReflectiveEndecBuilder.SHARED_INSTANCE.get(ModifierDefinition.class);
    }
    
    // apply a custom modification, that implements custom functionality.
    public record CustomAugmentDefinition(class_2960 customAugmentId) {
        public static Endec<CustomAugmentDefinition> ENDEC = ReflectiveEndecBuilder.SHARED_INSTANCE.get(CustomAugmentDefinition.class);
    }
    
}
