package rearth.oritech.init.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import rearth.oritech.Oritech;
import rearth.oritech.init.recipes.OritechRecipe;

public class OritechEMIParticleCollisionRecipe extends BasicEmiRecipe {
    
    public static final class_2960 PARTICLE_RECIPE_OVERLAY = Oritech.id("textures/gui/modular/particle_recipe_overlay.png");
    
    private final OritechRecipe recipe;
    
    public OritechEMIParticleCollisionRecipe(class_8786<OritechRecipe> entry, EmiRecipeCategory category) {
        super(category, entry.comp_1932(), 160, 60);
        
        recipe = entry.comp_1933();
        recipe.getInputs().forEach(ingredient -> this.inputs.add(EmiIngredient.of(ingredient)));
        recipe.getResults().forEach(stack -> this.outputs.add(EmiStack.of(stack)));
    }
    
    @Override
    public void addWidgets(WidgetHolder widgets) {
        
        widgets.addTexture(PARTICLE_RECIPE_OVERLAY, 60, 17, 36, 24, 0, 0, 36, 24, 36, 24);

        widgets.addSlot(this.inputs.get(0), 42, 20);
        widgets.addSlot(this.inputs.get(1), 96, 20);
        
        
        widgets.addSlot(this.outputs.get(0), 69, 20).recipeContext(this).drawBack(false);
        widgets.addText(class_2561.method_43469("emi.title.oritech.collisionspeed", this.recipe.getTime()), 0, (int) (getDisplayHeight() * 0.88), 0xFFFFFF, true);
        
    }
}
