package rearth.oritech.block.blocks.pipes.energy;

import rearth.oritech.block.blocks.pipes.GenericPipeDuctBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;

import static rearth.oritech.block.blocks.pipes.energy.EnergyPipeBlock.ENERGY_PIPE_DATA;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public class EnergyPipeDuctBlock extends GenericPipeDuctBlock {
	public EnergyPipeDuctBlock(class_2251 settings) {
		super(settings);
	}

	@Override
	public class_2680 getConnectionBlock() {
		return getNormalBlock();
	}

	@Override
	public class_2680 getNormalBlock() {
		return BlockContent.ENERGY_PIPE_DUCT_BLOCK.method_9564();
	}

	@Override
	public String getPipeTypeName() {
		return "energy";
	}

	@Override
	public boolean connectToOwnBlockType(class_2248 block) {
		return block instanceof EnergyPipeDuctBlock || block instanceof EnergyPipeBlock ||block instanceof EnergyPipeConnectionBlock;
	}

	@Override
	public GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(class_1937 world) {
		return ENERGY_PIPE_DATA.computeIfAbsent(world.method_27983().method_29177(), data -> new GenericPipeInterfaceEntity.PipeNetworkData());
	}
}
