/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.interaction;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9300;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockFrameInteractionEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.FakeMachinePlayer;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class DestroyerBlockEntity
extends MultiblockFrameInteractionEntity {
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasCropFilterAddon;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasSilkTouchAddon;
    @SyncField(value={SyncType.GUI_OPEN})
    public int yieldAddons = 0;
    @SyncField(value={SyncType.GUI_OPEN, SyncType.SPARSE_TICK})
    public int range = 1;
    @SyncField
    public class_2338 quarryTarget = class_2338.field_10980;
    public float targetHardness = 1.0f;
    private class_3222 destroyerPlayerEntity = null;

    public DestroyerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.DESTROYER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.range = 1;
        this.yieldAddons = 0;
        this.hasSilkTouchAddon = false;
        super.gatherAddonStats(addons);
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        if (addonBlock.state().method_26204().equals(BlockContent.CROP_FILTER_ADDON)) {
            this.hasCropFilterAddon = true;
        }
        if (addonBlock.state().method_26204().equals(BlockContent.QUARRY_ADDON)) {
            this.range *= 8;
        }
        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_YIELD_ADDON)) {
            ++this.yieldAddons;
        }
        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_SILK_TOUCH_ADDON)) {
            this.hasSilkTouchAddon = true;
        }
        super.getAdditionalStatFromAddon(addonBlock);
        this.yieldAddons = Math.min(this.yieldAddons, 3);
    }

    @Override
    public void resetAddons() {
        super.resetAddons();
        this.hasCropFilterAddon = false;
        this.hasSilkTouchAddon = false;
        this.range = 1;
        this.yieldAddons = 0;
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("cropAddon", this.hasCropFilterAddon);
        nbt.method_10556("silkTouchAddon", this.hasSilkTouchAddon);
        nbt.method_10569("range", this.range);
        nbt.method_10569("yield", this.yieldAddons);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.hasCropFilterAddon = nbt.method_10577("cropAddon");
        this.hasSilkTouchAddon = nbt.method_10577("silkTouchAddon");
        this.range = nbt.method_10550("range");
        this.yieldAddons = nbt.method_10550("yield");
    }

    @Override
    protected boolean hasWorkAvailable(class_2338 toolPosition) {
        if (this.range > 1) {
            return this.hasQuarryTarget(toolPosition);
        }
        class_2338 targetPosition = toolPosition.method_10074();
        class_2680 targetState = Objects.requireNonNull(this.field_11863).method_8320(targetPosition);
        if (this.hasCropFilterAddon && DestroyerBlockEntity.isImmatureCrop(targetState)) {
            return false;
        }
        return !targetState.method_26204().equals(class_2246.field_10124);
    }

    private class_1657 getDestroyerPlayerEntity() {
        class_1937 class_19372;
        if (this.destroyerPlayerEntity == null && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.destroyerPlayerEntity = FakeMachinePlayer.create(serverWorld, new GameProfile(UUID.randomUUID(), "oritech_destroyer"), this.inventory);
        }
        return this.destroyerPlayerEntity;
    }

    private boolean hasQuarryTarget(class_2338 toolPosition) {
        return this.getQuarryDownwardState(toolPosition) != null;
    }

    public static boolean isImmatureCrop(class_2680 targetState) {
        class_2302 cropBlock;
        class_2248 targetBlock = targetState.method_26204();
        return targetBlock instanceof class_2302 && !(cropBlock = (class_2302)targetBlock).method_9825(targetState) || targetBlock instanceof class_2421 && (Integer)targetState.method_11654((class_2769)class_2421.field_11306) < 3 || targetBlock instanceof class_2282 && (Integer)targetState.method_11654((class_2769)class_2282.field_10779) < 2;
    }

    private class_3545<class_2338, class_2680> getQuarryDownwardState(class_2338 toolPosition) {
        for (int i = 1; i <= this.range; ++i) {
            class_2338 checkPos = toolPosition.method_10087(i);
            class_2680 targetState = this.field_11863.method_8320(checkPos);
            if (targetState.method_26215() || !targetState.method_26227().method_15769()) continue;
            this.quarryTarget = checkPos;
            this.targetHardness = Math.clamp(targetState.method_26214((class_1922)this.field_11863, checkPos), 0.0f, 100.0f);
            return new class_3545((Object)checkPos, (Object)targetState);
        }
        this.quarryTarget = class_2338.field_10980;
        return null;
    }

    @Override
    public void finishBlockWork(class_2338 processed) {
        float targetHardness;
        class_2338 targetPosition = processed.method_10074();
        class_2680 targetState = Objects.requireNonNull(this.field_11863).method_8320(targetPosition);
        if (this.range > 1) {
            if (this.quarryTarget != class_2338.field_10980) {
                targetPosition = this.quarryTarget;
                targetState = this.field_11863.method_8320(targetPosition);
            } else {
                class_3545<class_2338, class_2680> data = this.getQuarryDownwardState(processed);
                if (data == null) {
                    return;
                }
                targetPosition = (class_2338)data.method_15442();
                targetState = (class_2680)data.method_15441();
            }
        }
        if (!targetState.method_26227().method_15769()) {
            this.field_11863.method_8501(targetPosition, class_2246.field_10124.method_9564());
        }
        if ((targetHardness = targetState.method_26204().method_36555()) < 0.0f) {
            return;
        }
        if (this.range == 1 && this.hasCropFilterAddon && DestroyerBlockEntity.isImmatureCrop(targetState)) {
            return;
        }
        if (!targetState.method_26204().equals(class_2246.field_10124)) {
            class_2586 targetEntity = this.field_11863.method_8321(targetPosition);
            List dropped = this.hasSilkTouchAddon ? DestroyerBlockEntity.getSilkTouchDrops(targetState, (class_3218)this.field_11863, targetPosition, targetEntity, this.getDestroyerPlayerEntity()) : (this.yieldAddons > 0 ? DestroyerBlockEntity.getLootDrops(targetState, (class_3218)this.field_11863, targetPosition, targetEntity, this.yieldAddons, this.getDestroyerPlayerEntity()) : class_2248.method_9562((class_2680)targetState, (class_3218)((class_3218)this.field_11863), (class_2338)targetPosition, (class_2586)targetEntity));
            if (dropped.isEmpty()) {
                dropped = class_2248.method_9609((class_2680)targetState, (class_3218)((class_3218)this.field_11863), (class_2338)targetPosition, (class_2586)targetEntity, null, (class_1799)new class_1799((class_1935)class_1802.field_8868));
            }
            for (class_1799 stack : dropped) {
                if (this.inventory.insert(stack, true) == stack.method_7947()) continue;
                return;
            }
            for (class_1799 stack : dropped) {
                this.inventory.insert(stack, false);
            }
            targetState.method_26204().method_9576(this.field_11863, targetPosition, targetState, this.getDestroyerPlayerEntity());
            this.field_11863.method_8396(null, targetPosition, targetState.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
            this.field_11863.method_22352(targetPosition, false);
            super.finishBlockWork(processed);
        }
    }

    public static List<class_1799> getLootDrops(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, int yieldAddons, @Nullable class_1657 entity) {
        class_1799 sampleTool = new class_1799((class_1935)class_1802.field_22024);
        sampleTool.method_57379(class_9334.field_49630, (Object)new class_9300(false));
        class_6880.class_6883 fortuneEntry = (class_6880.class_6883)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9130).get();
        sampleTool.method_7978((class_6880)fortuneEntry, Math.min(yieldAddons, 3));
        class_8567.class_8568 builder = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)sampleTool).method_51877(class_181.field_1228, (Object)blockEntity);
        if (entity != null) {
            builder.method_51877(class_181.field_1226, (Object)entity);
        }
        return state.method_26189(builder);
    }

    public static List<class_1799> getSilkTouchDrops(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, @Nullable class_1657 entity) {
        class_1799 sampleTool = new class_1799((class_1935)class_1802.field_22024);
        sampleTool.method_57379(class_9334.field_49630, (Object)new class_9300(false));
        class_6880.class_6883 silkTouchEntry = (class_6880.class_6883)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9099).get();
        sampleTool.method_7978((class_6880)silkTouchEntry, 1);
        class_8567.class_8568 builder = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)sampleTool).method_51877(class_181.field_1228, (Object)blockEntity);
        if (entity != null) {
            builder.method_51877(class_181.field_1226, (Object)entity);
        }
        return state.method_26189(builder);
    }

    @Override
    protected void doProgress(boolean moving) {
        super.doProgress(moving);
        if (moving) {
            return;
        }
        if (this.range > 1 && this.quarryTarget != class_2338.field_10980) {
            ParticleContent.QUARRY_DESTROY_EFFECT.spawn(this.field_11863, class_243.method_24953((class_2382)this.quarryTarget).method_1031(0.0, 0.5, 0.0), (Object)3);
        } else if (this.hasWorkAvailable(this.getCurrentTarget())) {
            ParticleContent.BLOCK_DESTROY_EFFECT.spawn(this.field_11863, class_243.method_24954((class_2382)this.getCurrentTarget().method_10074()), (Object)4);
        }
    }

    @Override
    public List<class_3545<class_2561, class_2561>> getExtraExtensionLabels() {
        if (this.range == 1 && this.yieldAddons == 0 && !this.hasSilkTouchAddon) {
            return super.getExtraExtensionLabels();
        }
        if (this.hasSilkTouchAddon) {
            return List.of(new class_3545((Object)class_2561.method_43469((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.range}), (Object)class_2561.method_43471((String)"tooltip.oritech.block_destroyer.addon_range")), new class_3545((Object)class_2561.method_43471((String)"enchantment.minecraft.silk_touch"), (Object)class_2561.method_43471((String)"tooltip.oritech.machine.addon_silk_touch")));
        }
        return List.of(new class_3545((Object)class_2561.method_43469((String)"title.oritech.machine.addon_range", (Object[])new Object[]{this.range}), (Object)class_2561.method_43471((String)"tooltip.oritech.block_destroyer.addon_range")), new class_3545((Object)class_2561.method_43469((String)"title.oritech.machine.addon_fortune", (Object[])new Object[]{this.yieldAddons}), (Object)class_2561.method_43471((String)"tooltip.oritech.machine.addon_fortune")));
    }

    @Override
    public class_2680 getMachineHead() {
        return BlockContent.BLOCK_DESTROYER_HEAD.method_9564();
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 117, 20, true), new ScreenProvider.GuiSlot(1, 117, 38, true), new ScreenProvider.GuiSlot(2, 135, 20, true), new ScreenProvider.GuiSlot(3, 135, 38, true));
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(0, 0, -2), new class_2382(-1, 0, -1), new class_2382(0, 0, 2), new class_2382(-1, 0, 1));
    }

    @Override
    public float getMoveTime() {
        float quarrySpeedBonus = this.range > 1 ? 0.15f : 1.0f;
        return (float)Oritech.CONFIG.destroyerConfig.moveDuration() * this.getSpeedMultiplier() * quarrySpeedBonus;
    }

    @Override
    public float getWorkTime() {
        float quarrySpeedBonus = this.range > 1 ? 0.15f : 1.0f;
        return (float)((double)((float)Oritech.CONFIG.destroyerConfig.workDuration() * this.getSpeedMultiplier()) * Math.pow(this.targetHardness, 0.5) * (double)quarrySpeedBonus);
    }

    @Override
    public int getMoveEnergyUsage() {
        return Oritech.CONFIG.destroyerConfig.moveEnergyUsage();
    }

    @Override
    public int getOperationEnergyUsage() {
        int quarryCostBonus = this.range > 1 ? 4 : 1;
        return Oritech.CONFIG.destroyerConfig.workEnergyUsage() * quarryCostBonus;
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.DESTROYER_SCREEN;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 0, -1), new class_2382(0, 0, 1));
    }
}

