package rearth.oritech.block.entity.processing;

import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3861;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_9696;

public class PoweredFurnaceBlockEntity extends MultiblockMachineEntity {
    
    private final float FURNACE_SPEED_MULTIPLIER = Oritech.CONFIG.processingMachines.furnaceData.speedMultiplier();
    
    public PoweredFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.POWERED_FURNACE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.furnaceData.energyPerTick());
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.furnaceData.energyCapacity();
    }
    
    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.furnaceData.maxEnergyInsertion();
    }
    
    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.ASSEMBLER;
    }   // not used in this special case
    
    @Override
    protected float calculateEnergyUsage() {
        return energyPerTick * getEfficiencyMultiplier() * (1 / getSpeedMultiplier()) / 2;
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        
        if (!isActive(state)) return;
        
        var recipeCandidate = world.method_8433().method_8132(class_3956.field_17546, getFurnaceInput(), world);
        
        if (recipeCandidate.isPresent() && canAddToSlot(recipeCandidate.get().comp_1933().method_8110(world.method_30349()), inventory.heldStacks.get(1))) {
            if (hasEnoughEnergy()) {
                
                var activeRecipe = recipeCandidate.get().comp_1933();
                useEnergy();
                progress++;
                lastWorkedAt = world.method_8510();
                
                if (world.field_9229.method_43057() > 0.8)
                    ParticleContent.FURNACE_BURNING.spawn(world, class_243.method_24954(pos), 1);
                
                if (furnaceCraftingFinished(activeRecipe)) {
                    craftFurnaceItem(activeRecipe);
                    
                    for (int i = 0; i < this.getBaseAddonData().extraChambers(); i++) {
                        if (!canAddToSlot(recipeCandidate.get().comp_1933().method_8110(world.method_30349()), inventory.heldStacks.get(1)) || inventory.heldStacks.get(0).method_7960()) break;
                        craftFurnaceItem(activeRecipe);
                    }
                    
                    resetProgress();
                }
                
                method_5431();
                
            }
        } else {
            // this happens if either the input slot is empty, or the output slot is blocked
            if (progress > 0) resetProgress();
        }
        
        if (world.method_8510() % 18 == 0)
            updateFurnaceState(state);
        
    }
    
    private void updateFurnaceState(class_2680 state) {
        var wasLit = state.method_11654(class_2741.field_12548);
        var isLit = isActivelyWorking();
        
        if (wasLit != isLit) {
            field_11863.method_8501(field_11867, state.method_11657(class_2741.field_12548, isLit));
        }
        
    }
    
    private void craftFurnaceItem(class_3861 activeRecipe) {
        var result = activeRecipe.method_8110(field_11863.method_30349());
        var outSlot = inventory.heldStacks.get(1);
        var inSlot = inventory.heldStacks.get(0);
        
        inSlot.method_7934(1);
        if (outSlot.method_7960()) {
            inventory.heldStacks.set(1, result.method_7972());
        } else {
            outSlot.method_7933(result.method_7947());
        }
        
    }
    
    private boolean furnaceCraftingFinished(class_3861 activeRecipe) {
        return progress >= activeRecipe.method_8167() * getSpeedMultiplier();
    }
    
    private class_9696 getFurnaceInput() {
        return new class_9696(getInputView().get(0));
    }
    
    @SuppressWarnings("OptionalIsPresent")
    @Override
    public float getProgress() {
        if (progress == 0) return 0;
        
        var recipeCandidate = Objects.requireNonNull(field_11863).method_8433().method_8132(class_3956.field_17546, getFurnaceInput(), field_11863);
        if (recipeCandidate.isPresent()) {
            return (float) progress / getRecipeDuration();
        }
        
        return 0;
    }
    
    @SuppressWarnings("OptionalIsPresent")
    @Override
    protected int getRecipeDuration() {
        var recipeCandidate = Objects.requireNonNull(field_11863).method_8433().method_8132(class_3956.field_17546, getFurnaceInput(), field_11863);
        if (recipeCandidate.isPresent()) {
            return (int) (recipeCandidate.get().comp_1933().method_8167() * getSpeedMultiplier());
        }
        
        return 120;
    }
    
    @Override
    public float getSpeedMultiplier() {
        return super.getSpeedMultiplier() * FURNACE_SPEED_MULTIPLIER;
    }
    
    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 56, 38),
          new GuiSlot(1, 117, 38, true));
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.POWERED_FURNACE_SCREEN;
    }
    
    @Override
    public int getInventorySize() {
        return 2;
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(0, 1,0)
        );
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(
          new class_2382(0, -1,0)
        );
    }
}
