package rearth.oritech.block.entity.augmenter.api;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.Attachment;
import rearth.oritech.api.attachment.AttachmentApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.PlayerAugments;


import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

// all events / methods here are called just on the server (except for refreshClient()). However the augments are also present and loaded
// on the client with all their data and recipe.
public abstract class Augment {
    
    public static final Attachment<Map<class_2960, AugmentState>> ACTIVE_AUGMENTS_DATA = new Attachment<>() {
        @Override
        public class_2960 identifier() {
            return Oritech.id("playeraugments");
        }
        
        @Override
        public Codec<Map<class_2960, AugmentState>> persistenceCodec() {
            return Codec.unboundedMap(class_2960.field_25139, AugmentState.CODEC);
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public class_9139<ByteBuf, Map<class_2960, AugmentState>> networkCodec() {
            return class_9135.method_56377(HashMap::new, class_2960.field_48267, NetworkManager.getAutoCodec(AugmentState.class));
        }
        
        @Override
        public Supplier<Map<class_2960, AugmentState>> initializer() {
            return HashMap::new;
        }
    };
    
    public static void registerAttachmentTypes() {
        AttachmentApi.register(ACTIVE_AUGMENTS_DATA);
        AttachmentApi.register(CustomAugmentsCollection.PORTAL_TARGET_TYPE);
    }
    
    public final class_2960 id;
    public final boolean toggleable;
    
    protected Augment(class_2960 id, boolean toggleable) {
        this.id = id;
        this.toggleable = toggleable;
    }
    
    public boolean isInstalled(class_1657 player) {
        var data = AttachmentApi.getAttachmentValue(player, ACTIVE_AUGMENTS_DATA);
        var state = data.getOrDefault(id, AugmentState.NOT_INSTALLED);
        return !state.equals(AugmentState.NOT_INSTALLED);
    }
    
    public void installToPlayer(class_1657 player) {
        var data = new HashMap<>(AttachmentApi.getAttachmentValue(player, ACTIVE_AUGMENTS_DATA));
        data.put(id, AugmentState.ENABLED);
        AttachmentApi.setAttachment(player, ACTIVE_AUGMENTS_DATA, data);
        
        activate(player);
    }
    
    public void removeFromPlayer(class_1657 player) {
        var data = new HashMap<>(AttachmentApi.getAttachmentValue(player, ACTIVE_AUGMENTS_DATA));
        data.put(id, AugmentState.NOT_INSTALLED);
        AttachmentApi.setAttachment(player, ACTIVE_AUGMENTS_DATA, data);
        
        deactivate(player);
    }
    
    public boolean isEnabled(class_1657 player) {
        var data = AttachmentApi.getAttachmentValue(player, ACTIVE_AUGMENTS_DATA);
        var state = data.getOrDefault(id, AugmentState.NOT_INSTALLED);
        return state.equals(AugmentState.ENABLED);
    }
    
    public void toggle(class_1657 player) {
        var data = new HashMap<>(AttachmentApi.getAttachmentValue(player, ACTIVE_AUGMENTS_DATA));
        var state = data.getOrDefault(id, AugmentState.NOT_INSTALLED);
        if (state.equals(AugmentState.ENABLED)) {
            state = AugmentState.DISABLED;
            deactivate(player);
        } else if (state.equals(AugmentState.DISABLED)) {
            state = AugmentState.ENABLED;
            activate(player);
        }
        data.put(id, state);
        AttachmentApi.setAttachment(player, ACTIVE_AUGMENTS_DATA, data);
    }
    
    // this is called once when the augment is installed / enabled
    public abstract void activate(class_1657 player);
    
    // this is called when the augment is removed / disabled
    public abstract void deactivate(class_1657 player);
    
    // this is called every N ticks while the augment is enabled
    public abstract void refreshServer(class_1657 player);
    
    public void refreshClient(class_1657 player) {
    }
    
    public abstract int refreshInterval();
    
    public enum AugmentState {
        ENABLED, DISABLED, NOT_INSTALLED;
        
        public static final Codec<AugmentState> CODEC = Codec.INT.flatXmap(
          id -> DataResult.success(AugmentState.values()[id]),
          augmentState -> DataResult.success(augmentState.ordinal())
        );
    }
    
}
