package rearth.oritech.util;

import rearth.oritech.Oritech;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3917;

public interface ScreenProvider {
    
    default List<class_3545<class_2561, class_2561>> getExtraExtensionLabels() {return List.of();}
    
    record GuiSlot (int index, int x, int y, boolean output) {
        public GuiSlot (int index, int x, int y) {
            this(index, x, y, false);
        }
    }

    record BarConfiguration(int x, int y, int width, int height) {}

    record ArrowConfiguration(class_2960 empty, class_2960 full, int x, int y, int width, int height, boolean horizontal) {}

    List<GuiSlot> getGuiSlots();

    default boolean showEnergy() {
        return true;
    }
    
    float getDisplayedEnergyUsage();
    
    default float getDisplayedEnergyTransfer() {
        return getDisplayedEnergyUsage() * 10;
    }

    float getProgress();
    
    InventoryInputMode getInventoryInputMode();
    class_1263 getDisplayedInventory();
    
    class_3917<?> getScreenHandlerType();
    
    default boolean inputOptionsEnabled() {return true;}
    
    default class_2769<class_2350> getBlockFacingProperty() {
        return class_2741.field_12481;
    }
    
    default boolean showProgress() {
        return true;
    }
    
    default boolean showArmor() {return false;}
    
    default boolean showExpansionPanel() {return true;}
    
    default boolean hasRedstoneControlAvailable() {return false;}
    
    default int receivedRedstoneSignal() {return 0;}
    
    default String currentRedstoneEffect() {return "";}

    default BarConfiguration getEnergyConfiguration() {
        return new BarConfiguration(7, 24, 15, 54);
    }
    default BarConfiguration getFluidConfiguration() {
        return new BarConfiguration(147, 6, 21, 74);
    }
    
    default Optional<String> getWikiLink() { return Optional.empty(); } // optional override. Expected format is "interaction/enderic_laser". Defaults to the item link defined in the pages markdown.
    
    default ArrowConfiguration getIndicatorConfiguration() {
        return new ArrowConfiguration(
                Oritech.id("textures/gui/modular/arrow_empty.png"),
                Oritech.id("textures/gui/modular/arrow_full.png"),
                80, 35, 29, 16, true);
    }

}
