package rearth.oritech.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_8149;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;


@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements class_8149 {
    
    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }
    
    @Override
    public class_1542 method_5775(class_1799 stack) {
        return method_5699(stack, 0.0F);
    }
    
    @SuppressWarnings("resource")
    @Override
    public class_1542 method_5699(class_1799 stack, float yOffset) {
        class_1309 thisEntity = (class_1309) (Object) this;
        class_1309 attacker = thisEntity.method_49107();
        
        if (stack.method_7960() || thisEntity.method_37908().field_9236) return null;
        
        if (!thisEntity.method_5805() && oritech$isLaser(attacker)) {
            ((class_1657)attacker).method_7270(stack);
            return null;
        }
        return super.method_5699(stack, yOffset);
    }
    
    @Inject(method = "dropExperience", at = @At(value = "HEAD"), cancellable = true)
    private void disableXpForLaser(class_1297 attacker, CallbackInfo ci) {
        if (oritech$isLaser(attacker))
            ci.cancel();
    }
    
    @Unique
    private boolean oritech$isLaser(class_1297 attacker) {
        return attacker instanceof class_1657 player && player.method_7334().getName().equals(LaserArmBlockEntity.LASER_PLAYER_NAME);
    }
}