package rearth.oritech.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Vector3f;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.client.init.ParticleContent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_827;

import static rearth.oritech.client.renderers.LaserArmRenderer.CUSTOM_LINES;


public class AcceleratorControllerRenderer implements class_827<AcceleratorControllerBlockEntity> {
    
    private record RenderedLine(float startedAt, List<class_243> positions) {
    }
    
    private final Map<AcceleratorControllerBlockEntity, RenderedLine> activeLines = new HashMap<>();
    
    @Override
    public int method_33893() {
        return 128;
    }
    
    @Override
    public boolean shouldRenderOffScreen(AcceleratorControllerBlockEntity blockEntity) {
        return true;
    }
    @Override
    public void render(AcceleratorControllerBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        
        if (entity.displayTrail == null) {
            activeLines.remove(entity);
            return;
        }
        
        var lineConsumer = vertexConsumers.getBuffer(CUSTOM_LINES);
        var time = entity.method_10997().method_8510() + tickDelta;
        
        // try adding new tail to lines
        var displayTrail = entity.displayTrail;
        if (!activeLines.containsKey(entity) || !activeLines.get(entity).positions.equals(displayTrail)) {
            activeLines.put(entity, new RenderedLine(time, displayTrail));
            ParticleContent.PARTICLE_MOVING.spawn(entity.method_10997(), displayTrail.getLast());
        }
        
        var activeLine = activeLines.get(entity);
        var line = activeLine.positions;
        var age = time - activeLine.startedAt;
        if (age >= 60) {
            if (entity.displayTrail.equals(activeLine.positions)) entity.displayTrail = null;
        }
        
        
        for (int i = 0; i < line.size() - 1; i++) {
            var start = line.get(i).method_1020(class_243.method_24954(entity.method_11016()));
            var end = line.get(i + 1).method_1020(class_243.method_24954(entity.method_11016()));
            
            var startPos = new Vector3f((float) start.field_1352, (float) start.field_1351, (float) start.field_1350);
            var endPos = new Vector3f((float) end.field_1352, (float) end.field_1351, (float) end.field_1350);
            
            var camPos = class_310.method_1551().field_1719.method_19538();
            var camDist = camPos.method_1020(line.get(i)).method_1033();
            RenderSystem.lineWidth((float) (40 / Math.sqrt(camDist)));
            
            displayLine(matrices, light, overlay, startPos, endPos, lineConsumer, 1);
        }
        
    }
    
    private static void displayLine(class_4587 matrices, int light, int overlay, Vector3f startPos, Vector3f endPos, class_4588 lineConsumer, float alpha) {
        
        matrices.method_22903();
        var cross = new Vector3f(endPos).sub(startPos).normalize().cross(0, 1, 0);
        var scaledAlpha = (int) (alpha * 255);
        
        lineConsumer.method_22918(matrices.method_23760().method_23761(), startPos.x, startPos.y, startPos.z)
          .method_1336(188, 22, 196, scaledAlpha)
          .method_60803(light)
          .method_22922(overlay)
          .method_22914(0, 1, 0);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), endPos.x, endPos.y, endPos.z)
          .method_1336(188, 22, 196, scaledAlpha)
          .method_60803(light)
          .method_22922(overlay)
          .method_22914(1, 0, 0);
        
        // render a second one at right angle to first one
        lineConsumer.method_22918(matrices.method_23760().method_23761(), startPos.x, startPos.y, startPos.z)
          .method_1336(188, 22, 196, scaledAlpha)
          .method_60803(light)
          .method_22922(overlay)
          .method_22914(cross.x, cross.y, cross.z);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), endPos.x, endPos.y, endPos.z)
          .method_1336(188, 22, 196, scaledAlpha)
          .method_60803(light)
          .method_22922(overlay)
          .method_22914(cross.x, cross.y, cross.z);
        matrices.method_22909();
    }
}
