package rearth.oritech.block.blocks.processing;

import com.mojang.serialization.MapCodec;
import dev.architectury.hooks.fluid.FluidStackHooks;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.ItemFluidApi;
import rearth.oritech.block.entity.processing.RefineryModuleBlockEntity;

import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.StackContext;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3965;
import net.minecraft.class_9062;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;
import static rearth.oritech.util.TooltipHelper.addMachineTooltip;


public class RefineryModuleBlock extends class_2383 implements class_2343 {
    
    public RefineryModuleBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11043).method_11657(ASSEMBLED, false));
    }
    
    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(class_2741.field_12481, ASSEMBLED);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return Objects.requireNonNull(super.method_9605(ctx)).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            
            var entity = world.method_8321(pos);
            if (!(entity instanceof MultiblockMachineController machineEntity)) {
                return class_1269.field_5812;
            }
            
            var wasAssembled = state.method_11654(ASSEMBLED);
            
            if (!wasAssembled) {
                var corePlaced = machineEntity.tryPlaceNextCore(player);
                if (corePlaced) return class_1269.field_5812;
            }
            
            var isAssembled = machineEntity.initMultiblock(state);
            
            // first time created
            if (isAssembled && !wasAssembled) {
                machineEntity.triggerSetupAnimation();
                return class_1269.field_5812;
            }
            
            if (!isAssembled) {
                player.method_43496(class_2561.method_43471("message.oritech.machine.missing_core"));
                return class_1269.field_5812;
            }
            
        }
        
        return class_1269.field_5812;
    }
    
    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        
        if (ItemFluidApi.tryFluidBlockItemInteraction(stack, world, pos, player, hand)) return class_9062.method_55644(true);
        
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.method_8608() && state.method_11654(ASSEMBLED)) {
            
            var entity = world.method_8321(pos);
            if (entity instanceof MultiblockMachineController machineEntity) {
                machineEntity.onControllerBroken();
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new RefineryModuleBlockEntity(pos, state);
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        tooltip.add(class_2561.method_43471("tooltip.oritech.refinery_module").method_27692(class_124.field_1080));
        addMachineTooltip(tooltip, this, this);
    }
}
