package rearth.oritech.block.base.entity;

import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.util.MultiblockMachineController;

import java.util.ArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public abstract class MultiblockMachineEntity extends UpgradableMachineBlockEntity implements MultiblockMachineController {
    
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList<>();
    
    @SyncField(SyncType.GUI_OPEN)
    private float coreQuality = 1f;
    
    public MultiblockMachineEntity(class_2591<?> type, class_2338 pos, class_2680 state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
    }
    
    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return coreBlocksConnected;
    }
    
    @Override
    public class_2350 getFacingForMultiblock() {
        return getFacing();
    }
    
    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        addMultiblockToNbt(nbt);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        loadMultiblockNbtData(nbt);
    }
    
    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return inventory;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public class_2338 getPosForMultiblock() {
        return field_11867;
    }
    
    @Override
    public class_1937 getWorldForMultiblock() {
        return field_11863;
    }
    
    @Override
    public boolean isActive(class_2680 state) {
        return state.method_11654(MultiblockMachine.ASSEMBLED);
    }
    
    // this seems to work as expected for some reason?
    public static class_2382 worldToRelativePos(class_2382 ownWorldPos, class_2382 worldPos, class_2350 ownFacing) {
        return worldPos.method_35852(ownWorldPos);
    }
    
    @Override
    public void triggerSetupAnimation() {
        triggerAnim("base_controller", "setup");
    }
}
