/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.item.ext;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import org.jetbrains.annotations.Nullable;

public interface IZetaItemExtensions {
    private Item self() {
        return (Item)this;
    }

    default public InteractionResult onItemUseFirstZeta(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public boolean isRepairableZeta(ItemStack stack) {
        return false;
    }

    default public boolean onEntityItemUpdateZeta(ItemStack stack, ItemEntity entity) {
        return false;
    }

    default public boolean doesSneakBypassUseZeta(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    default public boolean canEquipZeta(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return false;
    }

    default public boolean isBookEnchantableZeta(ItemStack stack, ItemStack book) {
        return true;
    }

    default public int getEnchantmentValueZeta(ItemStack stack) {
        return 0;
    }

    default public boolean canShearZeta(ItemStack stack) {
        return stack.getItem() instanceof ShearsItem;
    }

    default public int getEnchantmentLevelZeta(ItemStack stack, Holder<Enchantment> enchantment) {
        ItemEnchantments itemenchantments = stack.getTagEnchantments();
        return itemenchantments.getLevel(enchantment);
    }

    @Deprecated
    default public ItemEnchantments getAllEnchantmentsZeta(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        return (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
    }

    default public boolean shouldCauseReequipAnimationZeta(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    default public int getBurnTimeZeta(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        FurnaceFuel furnaceFuel = (FurnaceFuel)stack.getItem().builtInRegistryHolder().getData(NeoForgeDataMaps.FURNACE_FUELS);
        return furnaceFuel == null ? 0 : furnaceFuel.burnTime();
    }

    default public <T extends LivingEntity> int damageItemZeta(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        return amount;
    }

    default public boolean isEnderMaskZeta(ItemStack stack, Player player, EnderMan enderboy) {
        return stack.getItem() == Items.CARVED_PUMPKIN;
    }

    default public boolean canElytraFlyZeta(ItemStack stack, LivingEntity entity) {
        return stack.getItem() instanceof ElytraItem && ElytraItem.isFlyEnabled((ItemStack)stack);
    }
}

