/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block.ext;

import com.google.common.collect.BiMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;

public interface IZetaBlockExtensions {
    public static final IZetaBlockExtensions DEFAULT = new IZetaBlockExtensions(){};

    default public int getLightEmissionZeta(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getLightEmission();
    }

    default public boolean isLadderZeta(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return state.is(BlockTags.CLIMBABLE);
    }

    default public boolean makesOpenTrapdoorAboveClimbableZeta(BlockState state, LevelReader level, BlockPos pos, BlockState trapdoorState) {
        return state.getBlock() instanceof LadderBlock && state.getValue((Property)LadderBlock.FACING) == trapdoorState.getValue((Property)TrapDoorBlock.FACING);
    }

    default public TriState canSustainPlantZeta(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        return TriState.DEFAULT;
    }

    default public boolean isConduitFrameZeta(BlockState state, LevelReader level, BlockPos pos, BlockPos conduit) {
        return state.getBlock() == Blocks.PRISMARINE || state.getBlock() == Blocks.PRISMARINE_BRICKS || state.getBlock() == Blocks.SEA_LANTERN || state.getBlock() == Blocks.DARK_PRISMARINE;
    }

    default public float getEnchantPowerBonusZeta(BlockState state, LevelReader level, BlockPos pos) {
        return state.is(Blocks.BOOKSHELF) ? 1.0f : 0.0f;
    }

    default public SoundType getSoundTypeZeta(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return state.getSoundType();
    }

    default public Integer getBeaconColorMultiplierZeta(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        Integer n;
        Block block = state.getBlock();
        if (block instanceof BeaconBeamBlock) {
            BeaconBeamBlock bbeam = (BeaconBeamBlock)block;
            n = bbeam.getColor().getTextureDiffuseColor();
        } else {
            n = null;
        }
        return n;
    }

    default public boolean isStickyBlockZeta(BlockState state) {
        return state.getBlock() == Blocks.SLIME_BLOCK || state.getBlock() == Blocks.HONEY_BLOCK;
    }

    default public boolean canStickToZeta(BlockState state, BlockState other) {
        if (state.getBlock() == Blocks.HONEY_BLOCK && other.getBlock() == Blocks.SLIME_BLOCK) {
            return false;
        }
        if (state.getBlock() == Blocks.SLIME_BLOCK && other.getBlock() == Blocks.HONEY_BLOCK) {
            return false;
        }
        return state.isStickyBlock() || other.isStickyBlock();
    }

    default public int getFlammabilityZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return ((FireBlock)Blocks.FIRE).getBurnOdds(state);
    }

    default public boolean isFlammableZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.getFlammabilityZeta(state, world, pos, face) > 0;
    }

    default public int getFireSpreadSpeedZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return ((FireBlock)Blocks.FIRE).getIgniteOdds(state);
    }

    default public boolean collisionExtendsVerticallyZeta(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return state.is(BlockTags.FENCES) || state.is(BlockTags.WALLS) || state.getBlock() instanceof FenceGateBlock;
    }

    default public boolean shouldDisplayFluidOverlayZeta(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return state.getBlock() instanceof HalfTransparentBlock || state.getBlock() instanceof LeavesBlock;
    }

    @Nullable
    default public BlockState getToolModifiedStateZeta(BlockState state, UseOnContext context, ItemAbility ability, boolean simulate) {
        return switch (ability.toString()) {
            case "axe_strip" -> AxeItem.getAxeStrippingState((BlockState)state);
            case "axe_scrape" -> WeatheringCopper.getPrevious((BlockState)state).orElse(null);
            case "axe_wax_off" -> Optional.ofNullable((Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state)).orElse(null);
            case "shovel_flatten" -> ShovelItem.getShovelPathingState((BlockState)state);
            case "hoe_till" -> {
                Block block = state.getBlock();
                if (block == Blocks.ROOTED_DIRT) {
                    if (!simulate && !context.getLevel().isClientSide) {
                        Block.popResourceFromFace((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (ItemStack)new ItemStack((ItemLike)Items.HANGING_ROOTS));
                    }
                    yield Blocks.DIRT.defaultBlockState();
                }
                if ((block == Blocks.GRASS_BLOCK || block == Blocks.DIRT_PATH || block == Blocks.DIRT || block == Blocks.COARSE_DIRT) && context.getLevel().getBlockState(context.getClickedPos().above()).isAir()) {
                    if (block == Blocks.COARSE_DIRT) {
                        yield Blocks.DIRT.defaultBlockState();
                    }
                    yield Blocks.FARMLAND.defaultBlockState();
                }
                yield null;
            }
            default -> null;
        };
    }

    default public boolean isScaffoldingZeta(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return state.is(Blocks.SCAFFOLDING);
    }
}

