/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement.modifier;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import org.violetmoon.zeta.advancement.AdvancementModifier;
import org.violetmoon.zeta.api.IMutableAdvancement;
import org.violetmoon.zeta.mixin.mixins.AccessorContextAwarePredicate;
import org.violetmoon.zeta.module.ZetaModule;

public class WaxModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET_ON = ResourceLocation.withDefaultNamespace((String)"husbandry/wax_on");
    private static final ResourceLocation TARGET_OFF = ResourceLocation.withDefaultNamespace((String)"husbandry/wax_off");
    private final Set<Block> unwaxed;
    private final Set<Block> waxed;

    public WaxModifier(ZetaModule module, Set<Block> unwaxed, Set<Block> waxed) {
        super(module);
        this.unwaxed = unwaxed;
        this.waxed = waxed;
        Preconditions.checkArgument((!unwaxed.isEmpty() || !waxed.isEmpty() ? 1 : 0) != 0, (Object)"Advancement modifier list cant be empty");
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET_ON, (Object)TARGET_OFF);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv, RegistryAccess registry) {
        CriterionTriggerInstance criterionTriggerInstance;
        String title = res.getPath().replaceAll(".+/", "");
        Criterion<?> criterion = adv.getCriterion(title);
        if (criterion != null && (criterionTriggerInstance = criterion.triggerInstance()) instanceof ItemUsedOnLocationTrigger.TriggerInstance) {
            ItemUsedOnLocationTrigger.TriggerInstance iib = (ItemUsedOnLocationTrigger.TriggerInstance)criterionTriggerInstance;
            Predicate<LootContext> predicate = ((AccessorContextAwarePredicate)iib.location().get()).zeta$getCompositePredicates();
            ItemUsedOnLocationTrigger.TriggerInstance comb = (ItemUsedOnLocationTrigger.TriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(this.unwaxed)), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.HONEYCOMB})).triggerInstance();
            ItemUsedOnLocationTrigger.TriggerInstance axe = (ItemUsedOnLocationTrigger.TriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(this.waxed)), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.AXES)).triggerInstance();
            ((AccessorContextAwarePredicate)iib.location().get()).zeta$setCompositePredicates(res.equals((Object)TARGET_ON) ? predicate.or(((AccessorContextAwarePredicate)comb.location().get()).zeta$getCompositePredicates()) : predicate.or(((AccessorContextAwarePredicate)axe.location().get()).zeta$getCompositePredicates()));
        }
        return true;
    }
}

