/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.config;

import com.electronwill.nightconfig.core.file.FileWatcher;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.slf4j.Logger;
import org.violetmoon.zeta.config.IZetaConfigInternals;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;

public class ForgeBackedConfig
implements IZetaConfigInternals {
    private final Map<ValueDefinition<?>, ModConfigSpec.ConfigValue<?>> definitionsToValues = new HashMap();
    private long debounceTime = System.currentTimeMillis();
    private ModConfig config = null;

    public ForgeBackedConfig(SectionDefinition rootSection, ModConfigSpec.Builder forgeBuilder) {
        this.walkSection(rootSection, forgeBuilder, true);
    }

    private void walkSection(SectionDefinition sect, ModConfigSpec.Builder builder, boolean root) {
        if (!root) {
            builder.comment(sect.commentToArray());
            builder.push(sect.name);
        }
        for (ValueDefinition<?> value : sect.getValues()) {
            this.addValue(value, builder);
        }
        for (SectionDefinition subsection : sect.getSubsections()) {
            this.walkSection(subsection, builder, false);
        }
        if (!root) {
            builder.pop();
        }
    }

    private <T> void addValue(ValueDefinition<T> val, ModConfigSpec.Builder builder) {
        ModConfigSpec.ConfigValue forge;
        builder.comment(val.commentToArray());
        Object t = val.defaultValue;
        if (t instanceof List) {
            List list = (List)t;
            forge = builder.defineList(val.name, list, val::validate);
        } else {
            forge = builder.define(List.of(val.name), () -> val.defaultValue, val::validate, val.defaultValue.getClass());
        }
        this.definitionsToValues.put(val, forge);
    }

    @Override
    public <T> T get(ValueDefinition<T> definition) {
        ModConfigSpec.ConfigValue<?> forge = this.definitionsToValues.get(definition);
        return (T)forge.get();
    }

    @Override
    public <T> void set(ValueDefinition<T> definition, T value) {
        ModConfigSpec.ConfigValue<?> forge = this.definitionsToValues.get(definition);
        this.debounceTime = System.currentTimeMillis();
        forge.set(value);
    }

    public void setModConfig(ModConfig config) {
        this.config = config;
    }

    @Override
    public void flush() {
        FileWatcher.defaultInstance().removeWatch(this.config.getFullPath());
        this.definitionsToValues.values().iterator().next().save();
        FileWatcher.defaultInstance().addWatchFuture(this.config.getFullPath(), (Runnable)new SuspiciouslyConfigWatcherShapedClazz(this.config, this.config.getFullPath()));
    }

    private static class SuspiciouslyConfigWatcherShapedClazz
    implements Runnable {
        private static final Logger LOGGER = LogUtils.getLogger();
        private static final Method LOAD_CONFIG = ObfuscationReflectionHelper.findMethod(ConfigTracker.class, (String)"loadConfig", (Class[])new Class[]{ModConfig.class, Path.class, Function.class});
        private static final Field LOCK = ObfuscationReflectionHelper.findField(ModConfig.class, (String)"lock");
        private final ModConfig modConfig;
        private final Path path;
        private final ClassLoader realClassLoader;

        SuspiciouslyConfigWatcherShapedClazz(ModConfig modConfig, Path path) {
            this.modConfig = modConfig;
            this.path = path;
            this.realClassLoader = Thread.currentThread().getContextClassLoader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            try {
                try {
                    ((Lock)LOCK.get(this.modConfig)).lock();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                try {
                    try {
                        LOAD_CONFIG.invoke(null, this.modConfig, this.path, ModConfigEvent.Reloading::new);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    try {
                        ((Lock)LOCK.get(this.modConfig)).unlock();
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousLoader);
            }
        }
    }
}

