/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.registry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.registry.BrewingRegistry;
import org.violetmoon.zetaimplforge.ForgeZeta;

public class ForgeBrewingRegistry
extends BrewingRegistry {
    private List<DelayedPotion> delayedPotions = new ArrayList<DelayedPotion>();
    private boolean okToRegisterImmediately = false;

    public ForgeBrewingRegistry(ForgeZeta zeta) {
        super(zeta);
    }

    @Override
    public void addBrewingRecipe(Potion input, Item reagentSupplier, Potion output) {
        DelayedPotion d = new DelayedPotion((Holder<Potion>)Holder.direct((Object)input), reagentSupplier, (Holder<Potion>)Holder.direct((Object)output));
        if (this.okToRegisterImmediately) {
            d.register();
        } else {
            this.delayedPotions.add(d);
        }
    }

    @LoadEvent
    public void commonSetup(ZCommonSetup event) {
        event.enqueueWork(() -> {
            this.okToRegisterImmediately = true;
            if (this.delayedPotions != null) {
                this.delayedPotions.forEach(DelayedPotion::register);
            }
            this.delayedPotions = null;
        });
    }

    @EventBusSubscriber
    private record DelayedPotion(Holder<Potion> input, Item reagentSupplier, Holder<Potion> output) {
        private static Set<DelayedPotion> delayedPotions = new HashSet<DelayedPotion>();

        void register() {
            delayedPotions.add(this);
        }

        @SubscribeEvent
        static void registryEventReal(RegisterBrewingRecipesEvent event) {
            PotionBrewing.Builder builder = event.getBuilder();
            for (DelayedPotion potion : delayedPotions) {
                builder.addMix(potion.input, potion.reagentSupplier, potion.output);
            }
        }
    }
}

