/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public interface SimpleFluidloggedBlock
extends BucketPickup,
LiquidBlockContainer {
    default public boolean canPlaceLiquid(@Nullable Player player, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Fluid fluid) {
        return this.fluidContained(state) == Fluids.EMPTY && this.acceptsFluid(fluid);
    }

    default public boolean placeLiquid(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluid) {
        if (this.canPlaceLiquid(null, (BlockGetter)level, pos, state, fluid.getType())) {
            if (!level.isClientSide()) {
                level.setBlock(pos, this.withFluid(state, fluid.getType()), 3);
                level.scheduleTick(pos, fluid.getType(), fluid.getType().getTickDelay((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    @NotNull
    default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        Fluid fluid = this.fluidContained(state);
        if (fluid != Fluids.EMPTY && fluid.getBucket() != Items.AIR) {
            level.setBlock(pos, this.withFluid(state, Fluids.EMPTY), 3);
            if (!state.canSurvive((LevelReader)level, pos)) {
                level.destroyBlock(pos, true);
            }
            return new ItemStack((ItemLike)fluid.getBucket());
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    default public Optional<SoundEvent> getPickupSound() {
        return Optional.empty();
    }

    default public Optional<SoundEvent> getPickupSound(BlockState state) {
        return this.fluidContained(state).getPickupSound();
    }

    public boolean acceptsFluid(@NotNull Fluid var1);

    @NotNull
    public BlockState withFluid(@NotNull BlockState var1, @NotNull Fluid var2);

    @NotNull
    public Fluid fluidContained(@NotNull BlockState var1);
}

