/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.world.generator.multichunk;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.Vec3;
import org.violetmoon.zeta.config.type.ClusterSizeConfig;

public record ClusterShape(BlockPos src, Vec3 radius, PerlinSimplexNoise noiseGenerator) {
    public boolean isInside(BlockPos pos) {
        double maxR;
        double dz;
        double dy;
        double dx = (double)(pos.getX() - this.src.getX()) / this.radius.x;
        double r = dx * dx + (dy = (double)(pos.getY() - this.src.getY()) / this.radius.y) * dy + (dz = (double)(pos.getZ() - this.src.getZ()) / this.radius.z) * dz;
        if (r > 1.0) {
            return false;
        }
        r = Math.sqrt(r);
        double phi = Math.atan2(dz, dx);
        double theta = r == 0.0 ? 0.0 : Math.acos(dy / r);
        double xn = phi + (double)this.src.getX();
        double yn = theta + (double)this.src.getZ();
        double noise = this.noiseGenerator.getValue(xn, yn, false);
        double cutoff = 2.356194490192345;
        if (phi > cutoff) {
            double noise0 = this.noiseGenerator.getValue(-Math.PI + (double)this.src.getX(), yn, false);
            noise = Mth.lerp((double)((phi - cutoff) / (Math.PI - cutoff)), (double)noise, (double)noise0);
        }
        return (maxR = noise + 0.5) - r > 0.0;
    }

    public int getUpperBound() {
        return (int)Math.ceil((double)this.src.getY() + this.radius.y());
    }

    public int getLowerBound() {
        return (int)Math.floor((double)this.src.getY() - this.radius.y());
    }

    public static class Provider {
        private final ClusterSizeConfig config;
        private final PerlinSimplexNoise noiseGenerator;

        public Provider(ClusterSizeConfig config, long seed) {
            this.config = config;
            this.noiseGenerator = new PerlinSimplexNoise((RandomSource)new LegacyRandomSource(seed), (List)ImmutableList.of((Object)-4, (Object)-3, (Object)-2, (Object)-1, (Object)0, (Object)1, (Object)2, (Object)3, (Object)4));
        }

        public ClusterShape around(BlockPos src) {
            Random rand = this.randAroundBlockPos(src);
            int radiusX = this.config.horizontalSize + rand.nextInt(this.config.horizontalVariation);
            int radiusY = this.config.verticalSize + rand.nextInt(this.config.verticalVariation);
            int radiusZ = this.config.horizontalSize + rand.nextInt(this.config.horizontalVariation);
            return new ClusterShape(src, new Vec3((double)radiusX, (double)radiusY, (double)radiusZ), this.noiseGenerator);
        }

        public int getRadius() {
            return this.config.horizontalSize + this.config.horizontalVariation;
        }

        public int getRarity() {
            return this.config.rarity;
        }

        public Random randAroundBlockPos(BlockPos pos) {
            return new Random(31L * (31L * (long)(31 + pos.getX()) + (long)pos.getY()) + (long)pos.getZ());
        }
    }
}

