/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util.handler;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import org.jetbrains.annotations.Nullable;

public class StructureBlockReplacementHandler {
    private static Set<StructureFunction> functions = new HashSet<StructureFunction>();
    private static final ThreadLocal<StructureHolder> structureHolder = new ThreadLocal();

    public static void addReplacement(StructureFunction func) {
        functions.add(func);
    }

    @Nullable
    public static Holder<Structure> getStructure(ServerLevelAccessor accessor, StructureHolder structure) {
        Optional registry = accessor.registryAccess().registry(Registries.STRUCTURE);
        Optional holder = registry.flatMap(reg -> reg.getResourceKey((Object)structure.currentStructure).flatMap(arg_0 -> ((Registry)reg).getHolder(arg_0)));
        return holder.isEmpty() ? null : (Holder)holder.get();
    }

    @Nullable
    public static ResourceKey<Structure> getStructureKey(ServerLevelAccessor accessor, StructureHolder structure) {
        Optional res = accessor.registryAccess().registry(Registries.STRUCTURE).flatMap(it -> it.getResourceKey((Object)structure.currentStructure));
        return res.isEmpty() ? null : (ResourceKey)res.get();
    }

    @Nullable
    public static ResourceLocation getStructureRes(ServerLevelAccessor accessor, StructureHolder structure) {
        Optional<ResourceLocation> res = accessor.registryAccess().registry(Registries.STRUCTURE).map(it -> it.getKey((Object)structure.currentStructure));
        return res.isEmpty() ? null : res.get();
    }

    public static boolean isStructure(ServerLevelAccessor accessor, StructureHolder structure, ResourceKey<Structure> target) {
        ResourceKey<Structure> curr = StructureBlockReplacementHandler.getStructureKey(accessor, structure);
        return curr != null && curr.equals(target);
    }

    public static BlockState getResultingBlockState(ServerLevelAccessor level, BlockState blockstate) {
        StructureHolder curr = StructureBlockReplacementHandler.getCurrentStructureHolder();
        if (curr != null && curr.currentStructure != null) {
            for (StructureFunction fun : functions) {
                BlockState res = fun.transformBlockstate(level, blockstate, curr);
                if (res == null) continue;
                return res;
            }
        }
        return blockstate;
    }

    private static StructureHolder getCurrentStructureHolder() {
        return structureHolder.get();
    }

    public static void setActiveStructure(Structure structure, PiecesContainer components) {
        StructureHolder curr = StructureBlockReplacementHandler.getCurrentStructureHolder();
        if (curr == null) {
            curr = new StructureHolder();
            structureHolder.set(curr);
        }
        curr.currentStructure = structure;
        curr.currentComponents = components == null ? null : components.pieces();
    }

    public static class StructureHolder {
        public Structure currentStructure;
        public List<StructurePiece> currentComponents;
    }

    @FunctionalInterface
    public static interface StructureFunction {
        public BlockState transformBlockstate(ServerLevelAccessor var1, BlockState var2, StructureHolder var3);
    }
}

