/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class LateBoundHolder<T>
implements Holder<T> {
    public final ResourceKey<T> key;
    @Nullable
    public T thing;
    public Registry<T> registry;

    public LateBoundHolder(ResourceKey<T> key) {
        this.key = key;
    }

    void bind(T thing, Registry<T> registry) {
        this.thing = thing;
        this.registry = registry;
    }

    public T value() {
        if (this.thing == null) {
            throw new IllegalStateException("LateBoundHolder: too early");
        }
        return this.thing;
    }

    public boolean isBound() {
        return this.thing != null;
    }

    public boolean is(ResourceLocation p_205713_) {
        return this.key.location().equals((Object)p_205713_);
    }

    public boolean is(ResourceKey<T> p_205712_) {
        return this.key.equals(p_205712_);
    }

    public boolean is(Predicate<ResourceKey<T>> p_205711_) {
        return p_205711_.test(this.key);
    }

    public boolean is(TagKey<T> tagKey) {
        return false;
    }

    public boolean is(Holder<T> holder) {
        return false;
    }

    public Stream<TagKey<T>> tags() {
        return Stream.of(new TagKey[0]);
    }

    public Either<ResourceKey<T>, T> unwrap() {
        if (this.thing == null) {
            return Either.left(this.key);
        }
        return Either.right(this.thing);
    }

    public Optional<ResourceKey<T>> unwrapKey() {
        return Optional.of(this.key);
    }

    public Holder.Kind kind() {
        return Holder.Kind.REFERENCE;
    }

    public boolean canSerializeIn(HolderOwner<T> what) {
        if (this.registry == null) {
            return false;
        }
        return this.registry.holderOwner().canSerializeIn(what);
    }
}

