/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.integration;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.config.ZetaGeneralConfig;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.integration.JeiGatherHints;
import org.violetmoon.zeta.mod.ZetaMod;
import org.violetmoon.zeta.module.IDisableable;
import org.violetmoon.zeta.util.RegistryUtil;
import org.violetmoon.zeta.util.zetalist.ZetaList;

@JeiPlugin
public class ZetaJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"zeta", (String)"zeta");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        ZetaMod.ZETA.configManager.addOnReloadListener("jei_plugin", configInternals -> ZetaJeiPlugin.removeDisabledIngredients(jeiRuntime, ZetaList.INSTANCE.getZetas()));
        ZetaList.INSTANCE.getZetas().forEach(z -> z.configManager.addOnReloadListener("jei_plugin", configInternals -> ZetaJeiPlugin.removeDisabledIngredients(jeiRuntime, List.of(z))));
    }

    private static void removeDisabledIngredients(@NotNull IJeiRuntime jeiRuntime, Iterable<Zeta> zetas) {
        for (Zeta z : zetas) {
            if (!ZetaGeneralConfig.hideDisabledContent) {
                return;
            }
            HashSet hidePotions = Sets.newHashSet();
            NonNullList stacksToHide = NonNullList.create();
            for (Holder h : z.registry.getRegisteredObjects(Registries.POTION)) {
                if (ZetaMod.ZETA.brewingRegistry.isEnabled((Potion)h.value())) continue;
                hidePotions.add((Potion)h.value());
            }
            if (!hidePotions.isEmpty()) {
                for (Item item : BuiltInRegistries.ITEM) {
                    if (!(item instanceof PotionItem) && !(item instanceof TippedArrowItem)) continue;
                    NonNullList potionStacks = NonNullList.create();
                    potionStacks.stream().filter(it -> {
                        if (it.has(DataComponents.POTION_CONTENTS)) {
                            return hidePotions.contains(((PotionContents)it.get(DataComponents.POTION_CONTENTS)).potion().get());
                        }
                        return false;
                    }).forEach(arg_0 -> stacksToHide.add(arg_0));
                }
            }
            for (Holder h : z.registry.getRegisteredObjects(Registries.ITEM)) {
                if (IDisableable.isEnabled((Item)h.value())) continue;
            }
            if (stacksToHide.isEmpty()) continue;
            Minecraft.getInstance().submitAsync(() -> jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)stacksToHide));
        }
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (!ZetaGeneralConfig.enableJeiItemInfo) {
            return;
        }
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        List<Item> blacklist = RegistryUtil.massRegistryGet(ZetaGeneralConfig.suppressedInfo, BuiltInRegistries.ITEM);
        for (Zeta z : ZetaList.INSTANCE.getZetas()) {
            z.loadBus.fire(new JeiGatherHints(registration, z.modid, registryAccess, blacklist), ZGatherHints.class);
        }
    }
}

