/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AlikeColorHandler
implements BlockColor,
ItemColor {
    private final BlockState likeState;
    private final ItemStack likeItem;

    public AlikeColorHandler(BlockState likeState, ItemStack likeItem) {
        this.likeState = likeState;
        this.likeItem = likeItem;
    }

    public AlikeColorHandler(BlockState likeState) {
        this(likeState, new ItemStack((ItemLike)likeState.getBlock()));
    }

    public <B extends Block> AlikeColorHandler(B block, Function<B, BlockState> stateExtractor) {
        this.likeState = stateExtractor.apply(block);
        this.likeItem = new ItemStack((ItemLike)this.likeState.getBlock());
    }

    public <B extends Block> AlikeColorHandler(Item item, Function<B, BlockState> stateExtractor) {
        this(Block.byItem((Item)item), stateExtractor);
    }

    public int getColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        return Minecraft.getInstance().getBlockColors().getColor(this.likeState, level, pos, tintIndex);
    }

    public int getColor(ItemStack stack, int tintIndex) {
        return Minecraft.getInstance().getItemColors().getColor(this.likeItem, tintIndex);
    }
}

