/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.violetmoon.zeta.mod.ZetaMod;
import org.violetmoon.zeta.module.IDisableable;

public class CreativeTabManager {
    private static final Object MUTEX = new Object();
    private static final Map<ResourceKey<CreativeModeTab>, CreativeTabAdditions> additions = new HashMap<ResourceKey<CreativeModeTab>, CreativeTabAdditions>();
    private static DaisyChain chain = null;
    private static final boolean ignChaining = false;

    public static synchronized void startChain(ResourceKey<CreativeModeTab> tab, boolean reversed, boolean behindParent, @Nullable ItemLike appendParent) {
        if (chain != null) {
            ZetaMod.LOGGER.error("CHAIN WAS STARTED WITHOUT FINISHING IT! DO NOT DO THIS!!! Ending chain now.");
            CreativeTabManager.endChain();
        }
        chain = new DaisyChain(tab, reversed, behindParent, appendParent);
    }

    public static DaisyChain queryChain() {
        return chain;
    }

    public static synchronized void endChain() {
        for (ItemLike itemFromChain : CreativeTabManager.chain.chainedItems) {
            CreativeTabAdditions tabAdditions = CreativeTabManager.getForTab(chain.getTab());
            if (CreativeTabManager.chain.appendParent == null) {
                tabAdditions.addAtEnd(itemFromChain);
                continue;
            }
            if (!CreativeTabManager.chain.behindParent) {
                tabAdditions.addInFront(itemFromChain, CreativeTabManager.chain.appendParent, false);
                continue;
            }
            tabAdditions.addBehind(itemFromChain, chain.getParent(), false);
        }
        chain = null;
    }

    public static void addToTab(ResourceKey<CreativeModeTab> tab, ItemLike item) {
        if (chain != null && chain.getTab().equals(tab)) {
            chain.addToChain(item);
        } else {
            CreativeTabManager.getForTab(tab).addAtEnd(item);
        }
    }

    public static void addNextToItem(ResourceKey<CreativeModeTab> tab, ItemLike item, ItemLike target, boolean behind) {
        if (chain != null && chain.getTab().equals(tab)) {
            chain.addToChain(item);
        } else {
            CreativeTabAdditions tabAdditions = CreativeTabManager.getForTab(tab);
            if (behind) {
                tabAdditions.addBehind(item, target, false);
            } else {
                tabAdditions.addInFront(item, target, false);
            }
        }
    }

    private static CreativeTabAdditions getForTab(ResourceKey<CreativeModeTab> tab) {
        return additions.computeIfAbsent(tab, tabRk -> new CreativeTabAdditions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        Object object = MUTEX;
        synchronized (object) {
            ResourceKey tabKey = event.getTabKey();
            if (additions.containsKey(tabKey)) {
                CreativeTabAdditions tabAdditions = additions.get(tabKey);
                for (ItemLike item : tabAdditions.appendToEnd) {
                    CreativeTabManager.acceptItem(event, item);
                }
                AtomicInteger firstTryIdiots = new AtomicInteger(0);
                AtomicInteger inOnSecond = new AtomicInteger(0);
                AtomicInteger failedBoth = new AtomicInteger(0);
                AtomicInteger doubleJeopardy = new AtomicInteger(0);
                AtomicInteger dailyDouble = new AtomicInteger(0);
                LinkedHashMultimap additionsAtAllItems = LinkedHashMultimap.create();
                tabAdditions.appendInFront.forEach((arg_0, arg_1) -> CreativeTabManager.lambda$buildContents$1((Multimap)additionsAtAllItems, arg_0, arg_1));
                tabAdditions.appendBehind.forEach((arg_0, arg_1) -> CreativeTabManager.lambda$buildContents$2((Multimap)additionsAtAllItems, arg_0, arg_1));
                LinkedHashMultimap round2 = LinkedHashMultimap.create();
                additionsAtAllItems.forEach((arg_0, arg_1) -> CreativeTabManager.lambda$buildContents$3(event, (Multimap)round2, doubleJeopardy, firstTryIdiots, arg_0, arg_1));
                round2.forEach((parent, childPair) -> {
                    if (event.getParentEntries().contains((Object)((ItemLike)childPair.getSecond()).asItem().getDefaultInstance())) {
                        ZetaMod.LOGGER.debug("HOLY SHIT DAILY DOUBLE?!?! FOR " + ((ItemLike)childPair.getSecond()).asItem().getDefaultInstance().getDisplayName().getString());
                        dailyDouble.getAndIncrement();
                    } else if (event.getParentEntries().contains((Object)parent.asItem().getDefaultInstance())) {
                        CreativeTabManager.acceptItemAtParent(event, (ItemLike)childPair.getSecond(), parent, (Boolean)childPair.getFirst());
                        inOnSecond.getAndIncrement();
                    } else {
                        CreativeTabManager.acceptItem(event, (ItemLike)childPair.getSecond());
                        failedBoth.getAndIncrement();
                    }
                });
                ZetaMod.LOGGER.debug(String.valueOf(tabKey.location()) + " - " + String.valueOf(firstTryIdiots) + "/" + String.valueOf(inOnSecond) + "/" + String.valueOf(failedBoth) + " - " + String.valueOf(doubleJeopardy) + "/" + String.valueOf(dailyDouble));
            }
        }
    }

    private static boolean isItemEnabled(ItemLike item) {
        IDisableable id;
        return !(item instanceof IDisableable) || (id = (IDisableable)item).isEnabled();
    }

    private static void acceptItem(BuildCreativeModeTabContentsEvent event, ItemLike item) {
        if (!CreativeTabManager.isItemEnabled(item)) {
            return;
        }
        if (item instanceof AppendsUniquely) {
            AppendsUniquely au = (AppendsUniquely)item;
            event.acceptAll(au.appendItemsToCreativeTab());
        } else {
            event.accept(item, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static void acceptItemAtParent(BuildCreativeModeTabContentsEvent event, ItemLike item, ItemLike parent, boolean behind) {
        if (!CreativeTabManager.isItemEnabled(item)) {
            return;
        }
        ItemStack parentStack = parent.asItem().getDefaultInstance();
        if (item instanceof AppendsUniquely) {
            AppendsUniquely au = (AppendsUniquely)item;
            for (ItemStack uniques : au.appendItemsToCreativeTab()) {
                if (behind) {
                    event.insertBefore(parentStack, uniques, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    continue;
                }
                event.insertAfter(parentStack, uniques, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        } else {
            ItemStack itemStack = item.asItem().getDefaultInstance();
            if (behind) {
                event.insertBefore(parentStack, itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            } else {
                event.insertAfter(parentStack, itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    public static ResourceKey<CreativeModeTab> getTabOfItem(ItemLike itemLike) {
        for (Map.Entry<ResourceKey<CreativeModeTab>, CreativeTabAdditions> entry : additions.entrySet()) {
            if (!entry.getValue().addedItems.contains(itemLike)) continue;
            return entry.getKey();
        }
        return CreativeModeTabs.BUILDING_BLOCKS;
    }

    private static /* synthetic */ void lambda$buildContents$3(BuildCreativeModeTabContentsEvent event, Multimap round2, AtomicInteger doubleJeopardy, AtomicInteger firstTryIdiots, ItemLike parent, Pair childPair) {
        if (!CreativeTabManager.isItemEnabled(parent)) {
            CreativeTabManager.acceptItem(event, (ItemLike)childPair.getSecond());
        } else if (!event.getParentEntries().contains((Object)parent.asItem().getDefaultInstance())) {
            round2.put((Object)parent, (Object)childPair);
        } else if (event.getParentEntries().contains((Object)((ItemLike)childPair.getSecond()).asItem().getDefaultInstance())) {
            ZetaMod.LOGGER.debug("DOUBLE JEOPARDY FOR " + ((ItemLike)childPair.getSecond()).asItem().getDefaultInstance().getDisplayName().getString());
            doubleJeopardy.getAndIncrement();
        } else {
            CreativeTabManager.acceptItemAtParent(event, (ItemLike)childPair.getSecond(), parent, (Boolean)childPair.getFirst());
            firstTryIdiots.getAndIncrement();
        }
    }

    private static /* synthetic */ void lambda$buildContents$2(Multimap additionsAtAllItems, ItemLike parent, ItemLike child) {
        additionsAtAllItems.put((Object)parent, (Object)new Pair((Object)true, (Object)child));
    }

    private static /* synthetic */ void lambda$buildContents$1(Multimap additionsAtAllItems, ItemLike parent, ItemLike child) {
        additionsAtAllItems.put((Object)parent, (Object)new Pair((Object)false, (Object)child));
    }

    public static class DaisyChain {
        private final ResourceKey<CreativeModeTab> tab;
        private final boolean reversed;
        private final boolean behindParent;
        @Nullable
        private final ItemLike appendParent;
        private List<ItemLike> chainedItems = new ArrayList<ItemLike>();

        public DaisyChain(ResourceKey<CreativeModeTab> tab, boolean reversed, boolean behindParent, @Nullable ItemLike appendParent) {
            this.tab = tab;
            this.behindParent = behindParent;
            this.reversed = reversed;
            this.appendParent = appendParent;
        }

        public DaisyChain(ResourceKey<CreativeModeTab> tab, boolean reversed) {
            this(tab, reversed, reversed, null);
        }

        public ResourceKey<CreativeModeTab> getTab() {
            return this.tab;
        }

        @Nullable
        public ItemLike getParent() {
            return this.appendParent;
        }

        public void addToChain(ItemLike item) {
            if (!this.reversed) {
                this.chainedItems.add(item);
            } else {
                this.chainedItems.addFirst(item);
            }
        }
    }

    private static class CreativeTabAdditions {
        private final List<ItemLike> appendToEnd = new ArrayList<ItemLike>();
        private final Multimap<ItemLike, ItemLike> appendBehind = LinkedHashMultimap.create();
        private final Multimap<ItemLike, ItemLike> appendInFront = LinkedHashMultimap.create();
        private List<ItemLike> addedItems = new ArrayList<ItemLike>();

        private CreativeTabAdditions() {
        }

        private void addBehind(ItemLike item, ItemLike parent, boolean addFirst) {
            if (!this.validateItem(item)) {
                return;
            }
            this.appendBehind.put((Object)parent, (Object)item);
        }

        private void addInFront(ItemLike item, ItemLike parent, boolean addFirst) {
            if (!this.validateItem(item)) {
                return;
            }
            this.appendInFront.put((Object)parent, (Object)item);
        }

        private void addAtEnd(ItemLike item) {
            if (!this.validateItem(item)) {
                return;
            }
            this.appendToEnd.add(item);
        }

        public boolean validateItem(ItemLike item) {
            if (this.addedItems.contains(item)) {
                ZetaMod.LOGGER.debug("DUPLICATED ITEM IN TAB - " + item.asItem().getDefaultInstance().getDisplayName().tryCollapseToString());
                return false;
            }
            this.addedItems.add(item);
            return true;
        }
    }

    public static interface AppendsUniquely
    extends ItemLike {
        public List<ItemStack> appendItemsToCreativeTab();
    }
}

