/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.config.ConfigFlagManager;
import org.violetmoon.zeta.config.ConfigObjectMapper;
import org.violetmoon.zeta.config.IZetaConfigInternals;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;
import org.violetmoon.zeta.config.ZetaGeneralConfig;
import org.violetmoon.zeta.event.load.ZGatherAdditionalFlags;
import org.violetmoon.zeta.module.ZetaCategory;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.module.ZetaModuleManager;

public class ConfigManager {
    public static Set<ConfigManager> EVIL_CONFIG_STORAGE_THAT_I_NEED = new HashSet<ConfigManager>();
    private final Zeta z;
    private final ConfigFlagManager cfm;
    private final SectionDefinition rootConfig;
    private final List<Consumer<IZetaConfigInternals>> databindings = new ArrayList<Consumer<IZetaConfigInternals>>();
    private final Map<String, Consumer<IZetaConfigInternals>> onReloadListeners = new HashMap<String, Consumer<IZetaConfigInternals>>();
    @Nullable
    private final SectionDefinition generalSection;
    private final Map<ZetaCategory, SectionDefinition> categoriesToSections = new HashMap<ZetaCategory, SectionDefinition>();
    private final Map<ZetaCategory, ValueDefinition<Boolean>> categoryEnabledOptions = new HashMap<ZetaCategory, ValueDefinition<Boolean>>();
    private final Map<ZetaModule, ValueDefinition<Boolean>> ignoreAntiOverlapOptions = new HashMap<ZetaModule, ValueDefinition<Boolean>>();
    private final Map<ZetaModule, ValueDefinition<Boolean>> moduleEnabledOptions = new HashMap<ZetaModule, ValueDefinition<Boolean>>();
    private final Set<ZetaCategory> enabledCategories = new HashSet<ZetaCategory>();

    public ConfigManager(Zeta z, Object rootPojo) {
        this.z = z;
        this.cfm = new ConfigFlagManager(z);
        ZetaModuleManager modules = z.modules;
        this.enabledCategories.addAll(modules.getCategories());
        SectionDefinition.Builder rootConfigBuilder = (SectionDefinition.Builder)new SectionDefinition.Builder().name("");
        if (rootPojo == null) {
            this.generalSection = null;
        } else {
            z.loadBus.subscribe(rootPojo).subscribe(rootPojo.getClass());
            z.playBus.subscribe(rootPojo).subscribe(rootPojo.getClass());
            this.generalSection = rootConfigBuilder.addSubsection(general -> ConfigObjectMapper.readInto((SectionDefinition.Builder)general.name("general"), rootPojo, this.databindings, this.cfm));
        }
        rootConfigBuilder.addSubsection(categories -> {
            categories.name("categories");
            for (ZetaCategory category : modules.getInhabitedCategories()) {
                this.categoryEnabledOptions.put(category, categories.addValue(b -> ((ValueDefinition.Builder)b.name(category.name)).defaultValue(true)));
            }
        });
        for (ZetaCategory category : modules.getInhabitedCategories()) {
            this.categoriesToSections.put(category, rootConfigBuilder.addSubsection(categorySectionBuilder -> {
                categorySectionBuilder.name(category.name);
                for (ZetaModule module : modules.modulesInCategory(category)) {
                    this.cfm.putModuleFlag(module);
                    this.moduleEnabledOptions.put(module, categorySectionBuilder.addValue(moduleEnabledOptionBuilder -> ((ValueDefinition.Builder)((ValueDefinition.Builder)((ValueDefinition.Builder)moduleEnabledOptionBuilder.name(module.displayName())).englishDisplayName(module.displayName())).comment(module.description())).defaultValue(module.enabledByDefault())));
                    categorySectionBuilder.addSubsection(moduleSectionBuilder -> {
                        ((SectionDefinition.Builder)((SectionDefinition.Builder)moduleSectionBuilder.name(module.lowerCaseName())).englishDisplayName(module.displayName())).comment(module.description());
                        ConfigObjectMapper.readInto(moduleSectionBuilder, module, this.databindings, this.cfm);
                        List<String> antiOverlap = module.antiOverlap();
                        if (!antiOverlap.isEmpty()) {
                            this.ignoreAntiOverlapOptions.put(module, moduleSectionBuilder.addValue(antiOverlapOptionBuilder -> {
                                ((ValueDefinition.Builder)((ValueDefinition.Builder)antiOverlapOptionBuilder.name("Ignore Anti Overlap")).comment("This feature disables itself if any of the following mods are loaded:")).defaultValue(false);
                                for (String modid : antiOverlap) {
                                    antiOverlapOptionBuilder.comment(" - " + modid);
                                }
                                ((ValueDefinition.Builder)antiOverlapOptionBuilder.comment("This is done to prevent content overlap.")).comment("You can turn this on to force the feature to be loaded even if the above mods are also loaded.");
                            }));
                        }
                    });
                }
            }));
        }
        z.loadBus.fire(() -> this.cfm, ZGatherAdditionalFlags.class);
        this.databindings.add(0, i -> {
            this.categoryEnabledOptions.forEach((category, option) -> this.setCategoryEnabled((ZetaCategory)category, (Boolean)i.get(option)));
            this.ignoreAntiOverlapOptions.forEach((module, option) -> module.setIgnoreAntiOverlap(!ZetaGeneralConfig.useAntiOverlap || (Boolean)i.get(option) != false));
            this.moduleEnabledOptions.forEach((module, option) -> {
                this.setModuleEnabled((ZetaModule)module, (Boolean)i.get(option));
                this.cfm.putModuleFlag((ZetaModule)module);
            });
            z.loadBus.fire(() -> this.cfm, ZGatherAdditionalFlags.class);
        });
        this.rootConfig = rootConfigBuilder.build();
        this.rootConfig.finish();
        EVIL_CONFIG_STORAGE_THAT_I_NEED.add(this);
    }

    public SectionDefinition getRootConfig() {
        return this.rootConfig;
    }

    @Nullable
    public SectionDefinition getGeneralSection() {
        return this.generalSection;
    }

    public SectionDefinition getCategorySection(ZetaCategory cat) {
        return this.categoriesToSections.get(cat);
    }

    public ValueDefinition<Boolean> getCategoryEnabledOption(ZetaCategory cat) {
        return this.categoryEnabledOptions.get(cat);
    }

    public ValueDefinition<Boolean> getModuleEnabledOption(ZetaModule module) {
        return this.moduleEnabledOptions.get(module);
    }

    private void setCategoryEnabled(ZetaCategory cat, boolean enabled) {
        if (enabled) {
            this.enabledCategories.add(cat);
        } else {
            this.enabledCategories.remove(cat);
        }
        for (ZetaModule mod : this.z.modules.modulesInCategory(cat)) {
            mod.setEnabled(this.z, mod.isEnabled());
        }
    }

    private void setModuleEnabled(ZetaModule module, boolean enabled) {
        module.setEnabled(this.z, enabled);
    }

    public boolean isCategoryEnabled(ZetaCategory cat) {
        return this.enabledCategories.contains(cat);
    }

    public ConfigFlagManager getConfigFlagManager() {
        return this.cfm;
    }

    public void onReload() {
        IZetaConfigInternals internals = this.z.configInternals;
        this.databindings.forEach(c -> c.accept(internals));
        this.onReloadListeners.values().forEach(r -> r.accept(internals));
    }

    public void addOnReloadListener(String id, Consumer<IZetaConfigInternals> consumer) {
        this.onReloadListeners.put(id, consumer);
        consumer.accept(this.z.configInternals);
    }
}

