/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.recipe;

import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.config.ConfigFlagManager;
import org.violetmoon.zeta.recipe.IZetaCustomIngredient;

public class FlagIngredient
implements IZetaCustomIngredient {
    private final Ingredient parent;
    private final ConfigFlagManager cfm;
    private final String flag;

    public FlagIngredient(Ingredient parent, String flag, ConfigFlagManager cfm) {
        this.parent = parent;
        this.cfm = cfm;
        this.flag = flag;
    }

    @Override
    public Stream<ItemStack> getItems() {
        return !this.cfm.getFlag(this.flag) ? Stream.empty() : Arrays.stream(this.parent.getItems());
    }

    @Override
    public boolean test(@Nullable ItemStack target) {
        return this.cfm.getFlag(this.flag) && this.parent.test(target);
    }

    @Override
    public boolean isSimple() {
        return this.parent.isSimple();
    }

    @Override
    public IngredientType<?> getType() {
        return null;
    }

    @Override
    public Zeta getZeta() {
        return this.cfm.zeta;
    }
}

