/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZLoadComplete;
import org.violetmoon.zeta.registry.DyeablesRegistry;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.registry.ZetaRegistry;

public abstract class ClientRegistryExtension {
    protected final Zeta z;
    protected final ZetaRegistry registry;
    protected final Map<RenderLayerRegistry.Layer, RenderType> resolvedTypes = new EnumMap<RenderLayerRegistry.Layer, RenderType>(RenderLayerRegistry.Layer.class);

    public ClientRegistryExtension(Zeta z) {
        this.z = z;
        this.registry = z.registry;
        this.resolvedTypes.put(RenderLayerRegistry.Layer.SOLID, RenderType.solid());
        this.resolvedTypes.put(RenderLayerRegistry.Layer.CUTOUT, RenderType.cutout());
        this.resolvedTypes.put(RenderLayerRegistry.Layer.CUTOUT_MIPPED, RenderType.cutoutMipped());
        this.resolvedTypes.put(RenderLayerRegistry.Layer.TRANSLUCENT, RenderType.translucent());
    }

    @LoadEvent
    public void registerItemColorHandlers(ZAddItemColorHandlers event) {
        DyeablesRegistry dyeables = this.z.dyeables;
        ClampedItemPropertyFunction isDyed = (stack, level, entity, i) -> dyeables.isDyed(stack) ? 1.0f : 0.0f;
        ItemColor color = (stack, layer) -> layer == 0 ? dyeables.getColor(stack).rgb() : 0xFFFFFF;
        ResourceLocation isDyedId = ResourceLocation.withDefaultNamespace((String)(this.z.modid + "_dyed"));
        for (Item item : dyeables.dyeableConditions.keySet()) {
            ItemProperties.register((Item)item, (ResourceLocation)isDyedId, (ItemPropertyFunction)isDyed);
            event.register(color, new ItemLike[]{item});
        }
    }

    @LoadEvent
    public void registerRenderLayers(ZClientSetup event) {
        this.z.renderLayerRegistry.finalize(this::doSetRenderLayer);
    }

    @LoadEvent
    public void onLoadComplete(ZLoadComplete event) {
        this.z.registry.validateColorsProviders();
    }

    protected abstract void doSetRenderLayer(Block var1, RenderLayerRegistry.Layer var2);
}

