/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.LinkedHashSet;
import java.util.Optional;
import math.fast.SpeedyMath;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.util.BlockUtils;

public class MiscUtil {
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final DyeColor[] CREATIVE_COLOR_ORDER = new DyeColor[]{DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK};

    public static BooleanProperty directionProperty(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> BlockStateProperties.DOWN;
            case Direction.UP -> BlockStateProperties.UP;
            case Direction.NORTH -> BlockStateProperties.NORTH;
            case Direction.SOUTH -> BlockStateProperties.SOUTH;
            case Direction.WEST -> BlockStateProperties.WEST;
            case Direction.EAST -> BlockStateProperties.EAST;
        };
    }

    public static void addGoalJustAfterLatestWithPriority(GoalSelector selector, int priority, Goal goal) {
        LinkedHashSet allGoals = new LinkedHashSet(selector.getAvailableGoals());
        WrappedGoal latestWithPriority = null;
        for (WrappedGoal wrappedGoal : allGoals) {
            if (wrappedGoal.getPriority() != priority) continue;
            latestWithPriority = wrappedGoal;
        }
        selector.removeAllGoals(g -> true);
        if (latestWithPriority == null) {
            selector.addGoal(priority, goal);
        }
        for (WrappedGoal wrappedGoal : allGoals) {
            selector.addGoal(wrappedGoal.getPriority(), wrappedGoal.getGoal());
            if (wrappedGoal != latestWithPriority) continue;
            selector.addGoal(priority, goal);
        }
    }

    public static void damageStack(ItemStack stack, int dmg, Player player, EquipmentSlot slot) {
        stack.hurtAndBreak(dmg, (LivingEntity)player, slot);
    }

    public static Vec2 getMinecraftAngles(Vec3 direction) {
        direction = direction.normalize();
        double pitch = Math.asin(direction.y);
        double yaw = Math.asin(direction.x / Math.cos(pitch));
        return new Vec2((float)(pitch * 180.0 / Math.PI), (float)(-yaw * 180.0 / Math.PI));
    }

    public static Vec2 getMinecraftAnglesLossy(Vec3 direction) {
        direction = direction.normalize();
        double pitch = SpeedyMath.asin(direction.y);
        double yaw = SpeedyMath.asin(direction.x / SpeedyMath.cos(pitch));
        return new Vec2((float)(pitch * 180.0 / Math.PI), (float)(-yaw * 180.0 / Math.PI));
    }

    public static boolean validSpawnLight(ServerLevelAccessor world, BlockPos pos, RandomSource rand) {
        if (world.getBrightness(LightLayer.SKY, pos) > rand.nextInt(32)) {
            return false;
        }
        int light = world.getLevel().isThundering() ? world.getMaxLocalRawBrightness(pos, 10) : world.getMaxLocalRawBrightness(pos);
        return light == 0;
    }

    public static boolean validSpawnLocation(@NotNull EntityType<? extends Mob> type, @NotNull LevelAccessor world, MobSpawnType reason, BlockPos pos) {
        BlockPos below = pos.below();
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        BlockState state = world.getBlockState(below);
        return BlockUtils.isStoneBased(state, (BlockGetter)world, below) && state.isValidSpawn((BlockGetter)world, below, type);
    }

    public static void syncTE(BlockEntity tile) {
        Level level;
        Packet packet = tile.getUpdatePacket();
        if (packet != null && (level = tile.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(tile.getBlockPos()), false).forEach(e -> e.connection.send(packet));
        }
    }

    public static ItemStack putIntoInv(ItemStack stack, LevelAccessor level, BlockPos blockPos, BlockEntity tile, Direction face, boolean simulate, boolean doSimulation) {
        Block block;
        SidedInvWrapper handler = null;
        if (level != null && blockPos != null && (block = level.getBlockState(blockPos).getBlock()) instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
            handler = new SidedInvWrapper(holder.getContainer(level.getBlockState(blockPos), level, blockPos), face);
        } else if (tile != null && level instanceof Level) {
            Level level1 = (Level)level;
            Optional<IItemHandler> optional = Optional.ofNullable((IItemHandler)level1.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, (Object)face));
            if (optional.isPresent()) {
                handler = optional.orElse((IItemHandler)new ItemStackHandler());
            } else if (tile instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)tile;
                handler = new SidedInvWrapper(container, face);
            } else if (tile instanceof Container) {
                Container container = (Container)tile;
                handler = new InvWrapper(container);
            }
        }
        if (handler != null) {
            return simulate && !doSimulation ? ItemStack.EMPTY : ItemHandlerHelper.insertItem(handler, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    public static boolean canPutIntoInv(ItemStack stack, LevelAccessor level, BlockPos blockPos, BlockEntity tile, Direction face, boolean doSimulation) {
        return MiscUtil.putIntoInv(stack, level, blockPos, tile, face, true, doSimulation).isEmpty();
    }

    public static BlockState fromString(String key) {
        try {
            BlockStateParser.BlockResult result = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(key), (boolean)false);
            BlockState state = result.blockState();
            return state == null ? Blocks.AIR.defaultBlockState() : state;
        }
        catch (CommandSyntaxException e) {
            return Blocks.AIR.defaultBlockState();
        }
    }

    public static BlockBehaviour.Properties copyPropertySafe(BlockBehaviour blockBehaviour) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)blockBehaviour);
        p.lightLevel(s -> 0);
        p.offsetType(BlockBehaviour.OffsetType.NONE);
        p.mapColor(blockBehaviour.defaultMapColor());
        return p;
    }
}

